/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PlatformUtil {
    public static boolean onMacOSX() {
        String osname = System.getProperty("os.name");
        return osname.toLowerCase().contains("mac");
    }

    public static boolean onLinux() {
        String osname = System.getProperty("os.name");
        return osname.equalsIgnoreCase("linux");
    }

    public static boolean onWindows() {
        String osname = System.getProperty("os.name");
        return osname.toLowerCase().contains("windows");
    }

    public static boolean onIKVM() {
        return "IKVM.NET".equals(System.getProperty("java.runtime.name"));
    }

    public static String[] getBootClassPathJars() {
        String classpath;
        block11: {
            classpath = null;
            String javaVersion = System.getProperty("java.specification.version");
            if (!javaVersion.equals("1.8")) {
                try (Stream<Path> stream = Files.list(Paths.get(System.getProperty("java.home"), "jmods"));){
                    classpath = String.join((CharSequence)File.pathSeparator, stream.map(Path::toString).collect(Collectors.toList()));
                    break block11;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            classpath = System.getProperty("sun.boot.class.path");
        }
        if (classpath == null) {
            throw new IllegalStateException("could not find boot classpath");
        }
        String[] jars = classpath.split(File.pathSeparator);
        ArrayList<String> result = new ArrayList<String>();
        for (String jar : jars) {
            if (!jar.endsWith(".jar") && !jar.endsWith(".jmod") || !new File(jar).exists()) continue;
            result.add(jar);
        }
        return result.toArray(new String[0]);
    }

    public static int getJavaRuntimeVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }
}

