/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.SmallMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;

public class BimodalMap<K, V>
implements Map<K, V> {
    private final int cutOff;
    private @Nullable Map<K, V> backingStore;

    public BimodalMap(int cutoff) {
        this.cutOff = cutoff;
    }

    @Override
    public int size() {
        return this.backingStore == null ? 0 : this.backingStore.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingStore == null ? true : this.backingStore.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.backingStore == null ? false : this.backingStore.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.backingStore == null ? false : this.backingStore.containsValue(value);
    }

    @Override
    public @Nullable V get(Object key) {
        return this.backingStore == null ? null : (V)this.backingStore.get(key);
    }

    @Override
    public @Nullable V put(K key, V value) {
        if (this.backingStore == null) {
            this.backingStore = new SmallMap();
            this.backingStore.put(key, value);
            return null;
        }
        if (this.backingStore instanceof SmallMap) {
            V result = this.backingStore.put(key, value);
            if (this.backingStore.size() > this.cutOff) {
                this.transferBackingStore();
            }
            return result;
        }
        return this.backingStore.put(key, value);
    }

    @NullUnmarked
    private void transferBackingStore() {
        assert (this.backingStore instanceof SmallMap);
        SmallMap S = (SmallMap)this.backingStore;
        this.backingStore = HashMapFactory.make(2 * S.size());
        this.backingStore.putAll(S);
    }

    @Override
    public @Nullable V remove(Object key) {
        return this.backingStore == null ? null : (V)this.backingStore.remove(key);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> t) throws UnsupportedOperationException {
        if (t == null) {
            throw new IllegalArgumentException("null t");
        }
        if (this.backingStore == null) {
            int size = t.size();
            this.backingStore = size > this.cutOff ? HashMapFactory.make() : new SmallMap();
            this.backingStore.putAll(t);
            return;
        }
        if (!(this.backingStore instanceof SmallMap)) {
            this.backingStore.putAll(t);
            return;
        }
        if (t.size() > this.cutOff) {
            Map<K, V> old = this.backingStore;
            this.backingStore = HashMapFactory.make(t);
            this.backingStore.putAll(old);
            return;
        }
        this.backingStore.putAll(t);
        if (this.backingStore.size() <= this.cutOff) return;
        this.transferBackingStore();
    }

    @Override
    public void clear() {
        this.backingStore = null;
    }

    @Override
    public Set<K> keySet() {
        return this.backingStore == null ? Collections.emptySet() : this.backingStore.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.backingStore == null ? Collections.emptySet() : this.backingStore.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.backingStore == null ? Collections.emptySet() : this.backingStore.entrySet();
    }
}

