/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;

public class FilterIterator<T>
implements Iterator<T> {
    final Iterator<? extends T> i;
    final Predicate<? super T> f;
    private @Nullable T next = null;
    private boolean done = false;

    public FilterIterator(Iterator<? extends T> i, Predicate<? super T> f) {
        if (i == null) {
            throw new IllegalArgumentException("null i");
        }
        if (f == null) {
            throw new IllegalArgumentException("null f");
        }
        this.i = i;
        this.f = f;
        this.advance();
    }

    private void advance() {
        while (this.i.hasNext()) {
            T o = this.i.next();
            if (!this.f.test(o)) continue;
            this.next = o;
            return;
        }
        this.done = true;
    }

    @Override
    public @Nullable T next() throws NoSuchElementException {
        if (this.done) {
            throw new NoSuchElementException();
        }
        T o = this.next;
        this.advance();
        return o;
    }

    @Override
    public boolean hasNext() {
        return !this.done;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "filter " + this.f + " of " + this.i;
    }
}

