/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.util.collections.IVector;
import com.ibm.wala.util.collections.SparseVector;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.math.Logs;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;

public class TwoLevelVector<T>
implements IVector<T>,
Serializable {
    private static final long serialVersionUID = -835376054736611070L;
    private static final int PAGE_SIZE = 4096;
    private static final int LOG_PAGE_SIZE = Logs.log2(4096);
    private final Vector<SparseVector<T>> data = new Vector(0);
    private int maxPage = -1;

    @Override
    @NullUnmarked
    public @Nullable T get(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("invalid x: " + x);
        }
        int page = TwoLevelVector.getPageNumber(x);
        if (page >= this.data.size()) {
            return null;
        }
        IVector v = this.data.get(page);
        if (v == null) {
            return null;
        }
        int localX = x - TwoLevelVector.getFirstIndexOnPage(page);
        return v.get(localX);
    }

    private static int getFirstIndexOnPage(int page) {
        return page << LOG_PAGE_SIZE;
    }

    private static int getPageNumber(int x) {
        return x >> LOG_PAGE_SIZE;
    }

    @Override
    public void set(int x, @Nullable T value) {
        if (x < 0) {
            throw new IllegalArgumentException("illegal x: " + x);
        }
        int page = TwoLevelVector.getPageNumber(x);
        IVector<T> v = this.findOrCreatePage(page);
        int localX = TwoLevelVector.toLocalIndex(x, page);
        v.set(localX, value);
    }

    private static int toLocalIndex(int x, int page) {
        return x - TwoLevelVector.getFirstIndexOnPage(page);
    }

    private IVector<T> findOrCreatePage(int page) {
        if (page >= this.data.size()) {
            SparseVector v = new SparseVector();
            this.data.setSize(page + 1);
            this.data.add(page, v);
            this.maxPage = Math.max(page, this.maxPage);
            return v;
        }
        SparseVector<T> v = this.data.get(page);
        if (v == null) {
            v = new SparseVector();
            this.data.set(page, v);
            this.maxPage = Math.max(page, this.maxPage);
        }
        return v;
    }

    @Override
    public void performVerboseAction() {
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            final Iterator<SparseVector<T>> outer;
            @Nullable Iterator<T> inner;
            {
                for (IVector iVector : TwoLevelVector.this.data) {
                    Iterator it;
                    if (iVector == null || !(it = iVector.iterator()).hasNext()) continue;
                    this.inner = it;
                    break;
                }
            }

            @Override
            public boolean hasNext() {
                return this.inner != null;
            }

            @Override
            @NullUnmarked
            public T next() {
                Object result = this.inner.next();
                if (!this.inner.hasNext()) {
                    this.inner = null;
                    while (this.outer.hasNext()) {
                        Iterator it;
                        IVector v = this.outer.next();
                        if (v == null || !(it = v.iterator()).hasNext()) continue;
                        this.inner = it;
                        break;
                    }
                }
                return result;
            }

            @Override
            public void remove() {
                Assertions.UNREACHABLE();
            }
        };
    }

    @Override
    public int getMaxIndex() {
        if (this.maxPage == -1) {
            return -1;
        }
        IVector v = this.data.get(this.maxPage);
        int localMax = v.getMaxIndex();
        return this.maxPage * 4096 + localMax;
    }
}

