/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.ObjectVisitor;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;

public class Util {
    public static final BitSet EMPTY_BITSET = new BitSet();
    public static final boolean FULLY_QUALIFIED_NAMES = false;

    public static String str(Throwable thrown) throws IllegalArgumentException {
        if (thrown == null) {
            throw new IllegalArgumentException("thrown == null");
        }
        ByteArrayOutputStream traceDump = new ByteArrayOutputStream();
        try (PrintWriter w = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)traceDump, StandardCharsets.UTF_8)));){
            thrown.printStackTrace(w);
        }
        return traceDump.toString();
    }

    public static <S, T> Set<T> filterByType(Iterable<S> c, Class<T> klass) {
        HashSet result = HashSetFactory.make();
        for (S s : c) {
            if (!klass.isAssignableFrom(s.getClass())) continue;
            result.add(s);
        }
        return result;
    }

    public static <T> boolean forSome(Collection<T> c, Predicate<T> p) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException("c == null");
        }
        for (T t : c) {
            if (!p.test(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> @Nullable T find(Collection<T> c, Predicate<T> p) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException("c == null");
        }
        for (T obj : c) {
            if (!p.test(obj)) continue;
            return obj;
        }
        return null;
    }

    public static <T> boolean forAll(Collection<T> c, Predicate<T> p) throws NullPointerException {
        for (T t : c) {
            if (p.test(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> void doForAll(Collection<T> c, ObjectVisitor<T> v) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException("c == null");
        }
        for (T t : c) {
            v.visit(t);
        }
    }

    public static <T, U> List<U> map(List<T> srcList, Function<T, U> f) throws IllegalArgumentException {
        if (srcList == null) {
            throw new IllegalArgumentException("srcList == null");
        }
        ArrayList<U> result = new ArrayList<U>();
        for (T t : srcList) {
            result.add(f.apply(t));
        }
        return result;
    }

    public static <T, U> Set<U> mapToSet(Collection<T> srcSet, Function<T, U> f) throws IllegalArgumentException {
        if (srcSet == null) {
            throw new IllegalArgumentException("srcSet == null");
        }
        HashSet result = HashSetFactory.make();
        for (T t : srcSet) {
            result.add(f.apply(t));
        }
        return result;
    }

    public static int[] realloc(int[] data, int newSize) throws IllegalArgumentException {
        if (data == null) {
            throw new IllegalArgumentException("data == null");
        }
        if (data.length < newSize) {
            return Arrays.copyOf(data, newSize);
        }
        return data;
    }

    public static String objectFieldsToString(Object obj) throws IllegalArgumentException {
        Class<?> c;
        if (obj == null) {
            throw new IllegalArgumentException("obj == null");
        }
        SecurityManager oldsecurity = System.getSecurityManager();
        System.setSecurityManager(new SecurityManager(){

            @Override
            public void checkPermission(Permission perm) {
            }
        });
        StringBuilder buf = new StringBuilder(Util.removePackageName(c.getName()));
        for (c = obj.getClass(); c != Object.class; c = c.getSuperclass()) {
            Field[] fields = c.getDeclaredFields();
            if (fields.length > 0) {
                buf = buf.append(" (");
            }
            for (int i = 0; i < fields.length; ++i) {
                fields[i].setAccessible(true);
                try {
                    Class<?> type = fields[i].getType();
                    String name = fields[i].getName();
                    Object value = fields[i].get(obj);
                    buf = buf.append(name);
                    buf = buf.append('=');
                    buf = buf.append(value == null ? "null" : value.toString());
                    buf = buf.append(" : ");
                    buf = buf.append(Util.removePackageName(type.getName()));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                buf = buf.append(i + 1 >= fields.length ? ")" : ",");
            }
        }
        System.setSecurityManager(oldsecurity);
        return buf.toString();
    }

    public static @Nullable String removePackageName(String fully_qualified_name_) {
        if (fully_qualified_name_ == null) {
            return null;
        }
        int lastdot = fully_qualified_name_.lastIndexOf(46);
        if (lastdot < 0) {
            return "";
        }
        return fully_qualified_name_.substring(lastdot + 1);
    }

    public static <T> boolean intersecting(Set<T> s1, Set<T> s2) {
        return Util.forSome(s1, s2::contains);
    }

    public static String topLevelTypeString(String typeStr) throws IllegalArgumentException {
        if (typeStr == null) {
            throw new IllegalArgumentException("typeStr == null");
        }
        int dollarIndex = typeStr.indexOf(36);
        String topLevelTypeStr = dollarIndex == -1 ? typeStr : typeStr.substring(0, dollarIndex);
        return topLevelTypeStr;
    }

    public static <T> void addIfNotNull(T val, Collection<T> vals) {
        if (val != null) {
            vals.add(val);
        }
    }

    public static long getUsedMemory() {
        Util.gc();
        long totalMemory = Runtime.getRuntime().totalMemory();
        Util.gc();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long usedMemory = totalMemory - freeMemory;
        return usedMemory;
    }

    private static void gc() {
        try {
            for (int i = 0; i < 2; ++i) {
                System.gc();
                Thread.sleep(100L);
                System.runFinalization();
                Thread.sleep(100L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

