/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.impl;

import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.INodeWithNumberedEdges;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.graph.impl.DelegatingNumberedNodeManager;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.SparseIntSet;
import java.util.Iterator;
import org.jspecify.annotations.Nullable;

public class DelegatingNumberedEdgeManager<T extends INodeWithNumberedEdges>
implements NumberedEdgeManager<T> {
    private final DelegatingNumberedNodeManager<T> nodeManager;

    public DelegatingNumberedEdgeManager(DelegatingNumberedNodeManager<T> nodeManager) {
        if (nodeManager == null) {
            throw new IllegalArgumentException("nodeManager is null");
        }
        this.nodeManager = nodeManager;
    }

    @Override
    public Iterator<T> getPredNodes(@Nullable T N) throws IllegalArgumentException {
        if (N == null) {
            throw new IllegalArgumentException("N cannot be null");
        }
        T en = N;
        IntSet pred = en.getPredNumbers();
        EmptyIterator empty = EmptyIterator.instance();
        return pred == null ? empty : new IntSetNodeIterator(pred.intIterator());
    }

    @Override
    public IntSet getPredNodeNumbers(@Nullable T node) {
        if (node == null) {
            throw new IllegalArgumentException("N cannot be null");
        }
        T en = node;
        IntSet pred = en.getPredNumbers();
        return pred == null ? new SparseIntSet() : pred;
    }

    @Override
    public int getPredNodeCount(T N) throws IllegalArgumentException {
        if (N == null) {
            throw new IllegalArgumentException("N cannot be null");
        }
        T en = N;
        IntSet s = en.getPredNumbers();
        if (s == null) {
            return 0;
        }
        return s.size();
    }

    @Override
    public Iterator<T> getSuccNodes(@Nullable T N) {
        if (N == null) {
            throw new IllegalArgumentException("N cannot be null");
        }
        T en = N;
        IntSet succ = en.getSuccNumbers();
        EmptyIterator empty = EmptyIterator.instance();
        return succ == null ? empty : new IntSetNodeIterator(succ.intIterator());
    }

    @Override
    public int getSuccNodeCount(T N) {
        if (N == null) {
            throw new IllegalArgumentException("N is null");
        }
        T en = N;
        IntSet s = en.getSuccNumbers();
        return s == null ? 0 : s.size();
    }

    @Override
    public void addEdge(T src, T dst) {
        if (dst == null || src == null) {
            throw new IllegalArgumentException("parameter is null");
        }
        src.addSucc(dst.getGraphNodeId());
        dst.addPred(src.getGraphNodeId());
    }

    @Override
    public void removeEdge(T src, T dst) throws UnimplementedError {
        Assertions.UNREACHABLE("Implement me");
    }

    @Override
    public void removeAllIncidentEdges(T node) throws UnimplementedError {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        T n = node;
        n.removeAllIncidentEdges();
    }

    @Override
    public void removeIncomingEdges(T node) throws UnimplementedError {
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        T n = node;
        n.removeIncomingEdges();
    }

    @Override
    public void removeOutgoingEdges(T node) throws UnimplementedError {
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        T n = node;
        n.removeOutgoingEdges();
    }

    @Override
    public boolean hasEdge(@Nullable T src, @Nullable T dst) throws IllegalArgumentException {
        if (dst == null) {
            throw new IllegalArgumentException("dst == null");
        }
        return this.getSuccNodeNumbers(src).contains(dst.getGraphNodeId());
    }

    @Override
    public IntSet getSuccNodeNumbers(@Nullable T node) {
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        T en = node;
        IntSet succ = en.getSuccNumbers();
        return succ == null ? new SparseIntSet() : succ;
    }

    private class IntSetNodeIterator
    implements Iterator<T> {
        private final IntIterator delegate;

        IntSetNodeIterator(IntIterator delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public T next() {
            return (INodeWithNumberedEdges)DelegatingNumberedEdgeManager.this.nodeManager.getNode(this.delegate.next());
        }

        @Override
        public void remove() {
            Assertions.UNREACHABLE();
        }
    }
}

