/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.traverse;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.graph.Graph;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;

public class DFSPathFinder<T>
extends ArrayList<T> {
    public static final long serialVersionUID = 9939900773328288L;
    protected final Graph<T> G;
    private final Predicate<T> filter;
    private final Iterator<T> roots;
    protected final Map<Object, Iterator<? extends T>> pendingChildren = HashMapFactory.make(25);
    private boolean initialized = false;

    public DFSPathFinder(Graph<T> G, T N, Predicate<T> f) throws IllegalArgumentException {
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        if (!G.containsNode(N)) {
            throw new IllegalArgumentException("source node not in graph: " + N);
        }
        this.G = G;
        this.roots = new NonNullSingletonIterator<T>(N);
        this.filter = f;
    }

    public DFSPathFinder(Graph<T> G, Iterator<T> nodes, Predicate<T> f) {
        this.G = G;
        this.roots = nodes;
        this.filter = f;
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        if (this.roots == null) {
            throw new IllegalArgumentException("roots is null");
        }
        if (this.filter == null) {
            throw new IllegalArgumentException("filter is null");
        }
    }

    private void init() {
        this.initialized = true;
        if (this.roots.hasNext()) {
            T n = this.roots.next();
            this.push(n);
            this.setPendingChildren(n, this.getConnected(n));
        }
    }

    public @Nullable List<T> find() {
        if (!this.initialized) {
            this.init();
        }
        while (this.hasNext()) {
            T n = this.peek();
            if (this.filter.test(n)) {
                List<T> path = this.currentPath();
                this.advance();
                return path;
            }
            this.advance();
        }
        return null;
    }

    protected List<T> currentPath() {
        ArrayList result = new ArrayList();
        for (Object t : this) {
            result.add(0, t);
        }
        return result;
    }

    public boolean hasNext() {
        return !this.empty();
    }

    protected @Nullable Iterator<? extends T> getPendingChildren(T n) {
        return this.pendingChildren.get(n);
    }

    protected void setPendingChildren(T v, Iterator<? extends T> iterator) {
        this.pendingChildren.put(v, iterator);
    }

    private void advance() {
        T currentNode = this.peek();
        assert (this.getPendingChildren(currentNode) != null);
        do {
            T stackTop = this.peek();
            for (T child : Iterator2Iterable.make(this.getPendingChildren(stackTop))) {
                if (this.getPendingChildren(child) != null) continue;
                this.push(child);
                this.setPendingChildren(child, this.getConnected(child));
                return;
            }
            this.pop();
        } while (!this.empty());
        while (this.roots.hasNext()) {
            T nextRoot = this.roots.next();
            if (this.getPendingChildren(nextRoot) != null) continue;
            this.push(nextRoot);
            this.setPendingChildren(nextRoot, this.getConnected(nextRoot));
        }
    }

    protected Iterator<? extends T> getConnected(T n) {
        return this.G.getSuccNodes(n);
    }

    private boolean empty() {
        return this.size() == 0;
    }

    private void push(T elt) {
        this.add(elt);
    }

    private T peek() {
        return (T)this.get(this.size() - 1);
    }

    private T pop() {
        Object e = this.get(this.size() - 1);
        this.remove(this.size() - 1);
        return (T)e;
    }
}

