/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.traverse;

import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.traverse.DFSFinishTimeIterator;
import java.util.Arrays;
import java.util.Iterator;
import org.jspecify.annotations.Nullable;

public class NumberedDFSFinishTimeIterator<T>
extends DFSFinishTimeIterator<T> {
    public static final long serialVersionUID = 8737376661L;
    private Iterator<T>[] pendingChildren;
    private final NumberedGraph<T> G;

    NumberedDFSFinishTimeIterator(NumberedGraph<T> G, T N) {
        this.G = G;
        this.pendingChildren = new Iterator[G.getMaxNumber() + 1];
        this.init(G, new NonNullSingletonIterator<T>(N));
    }

    NumberedDFSFinishTimeIterator(NumberedGraph<T> G, Iterator<? extends T> nodes) {
        this.G = G;
        this.pendingChildren = new Iterator[G.getMaxNumber() + 1];
        this.init(G, nodes);
    }

    NumberedDFSFinishTimeIterator(NumberedGraph<T> G) {
        this(G, G.iterator());
    }

    @Override
    @Nullable Iterator<T> getPendingChildren(@Nullable T n) {
        int number = this.G.getNumber(n);
        if (number >= this.pendingChildren.length) {
            this.pendingChildren = Arrays.copyOf(this.pendingChildren, number * 2);
            return null;
        }
        if (number < 0) assert (false) : "negative number for " + n + " " + n.getClass();
        return this.pendingChildren[number];
    }

    @Override
    void setPendingChildren(@Nullable T v, Iterator<T> iterator) {
        this.pendingChildren[this.G.getNumber(v)] = iterator;
    }
}

