/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.tables;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.SimpleVector;
import com.ibm.wala.util.intset.BitVector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Table<T> {
    protected final ArrayList<SimpleVector<T>> rows = new ArrayList();
    protected final SimpleVector<String> columnHeadings = new SimpleVector();

    public Table() {
    }

    public Table(Table<T> t) throws IllegalArgumentException {
        if (t == null) {
            throw new IllegalArgumentException("t == null");
        }
        for (int i = 0; i < t.getNumberOfColumns(); ++i) {
            this.columnHeadings.set(i, t.getColumnHeading(i));
        }
    }

    public Table(String[] columns) throws IllegalArgumentException {
        if (columns == null) {
            throw new IllegalArgumentException("columns == null");
        }
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] == null) {
                throw new IllegalArgumentException("columns[" + i + "] is null");
            }
            this.columnHeadings.set(i, columns[i]);
        }
    }

    public String toString() {
        int[] format = this.computeColumnWidths();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.getNumberOfColumns(); ++i) {
            StringBuilder heading = new StringBuilder(this.getColumnHeading(i));
            Table.padWithSpaces(heading, format[i]);
            result.append((CharSequence)heading);
        }
        result.append('\n');
        for (int j = 0; j < this.getNumberOfRows(); ++j) {
            for (int i = 0; i < this.getNumberOfColumns(); ++i) {
                T e = this.getElement(j, i);
                StringBuilder element = e == null ? new StringBuilder() : new StringBuilder(e.toString());
                Table.padWithSpaces(element, format[i]);
                result.append((CharSequence)element);
            }
            result.append('\n');
        }
        return result.toString();
    }

    public synchronized T getElement(int row, int column) {
        try {
            SimpleVector<T> r = this.rows.get(row);
            return r.get(column);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("row: " + row + " column: " + column, e);
        }
    }

    public synchronized String getColumnHeading(int i) {
        return this.columnHeadings.get(i);
    }

    public int[] computeColumnWidths() {
        int[] result = new int[this.getNumberOfColumns()];
        for (int i = 0; i < this.getNumberOfColumns(); ++i) {
            result[i] = this.columnHeadings.get(i).length() + 1;
        }
        for (int j = 0; j < this.getNumberOfRows(); ++j) {
            for (int i = 0; i < this.getNumberOfColumns(); ++i) {
                T element = this.getElement(j, i);
                result[i] = element == null ? result[i] : Math.max(result[i], element.toString().length() + 1);
            }
        }
        return result;
    }

    public synchronized int getNumberOfColumns() {
        return this.columnHeadings.getMaxIndex() + 1;
    }

    public synchronized int getNumberOfRows() {
        return this.rows.size();
    }

    public synchronized Map<String, T> row2Map(int row) {
        HashMap<String, T> result = HashMapFactory.make();
        for (int j = 0; j < this.getNumberOfColumns(); ++j) {
            result.put(this.getColumnHeading(j), this.getElement(row, j));
        }
        return result;
    }

    public synchronized void addRow(Map<String, T> p) {
        if (p == null) {
            throw new IllegalArgumentException("null p " + p);
        }
        SimpleVector<T> r = new SimpleVector<T>();
        this.rows.add(r);
        for (int i = 0; i < this.getNumberOfColumns(); ++i) {
            r.set(i, p.get(this.getColumnHeading(i)));
        }
    }

    public synchronized void removeRow(Map<String, T> p) {
        int i;
        if (p == null) {
            throw new IllegalArgumentException("p is null");
        }
        BitVector toRemove = new BitVector();
        for (i = 0; i < this.rows.size(); ++i) {
            Map<String, T> row = this.row2Map(i);
            if (!row.equals(p)) continue;
            toRemove.set(i);
        }
        for (i = 0; i < this.rows.size(); ++i) {
            if (!toRemove.get(i)) continue;
            this.rows.remove(i);
        }
    }

    public static void padWithSpaces(StringBuilder b, int length) {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        if (b.length() < length) {
            b.append(" ".repeat(length - b.length()));
        }
    }
}

