/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class DeployReleaseOptions
extends GenericModel {
    protected String assistantId;
    protected String release;
    protected String environmentId;
    protected Boolean includeAudit;

    protected DeployReleaseOptions() {
    }

    protected DeployReleaseOptions(Builder builder) {
        Validator.notEmpty((String)builder.assistantId, (String)"assistantId cannot be empty");
        Validator.notEmpty((String)builder.release, (String)"release cannot be empty");
        Validator.notNull((Object)builder.environmentId, (String)"environmentId cannot be null");
        this.assistantId = builder.assistantId;
        this.release = builder.release;
        this.environmentId = builder.environmentId;
        this.includeAudit = builder.includeAudit;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String assistantId() {
        return this.assistantId;
    }

    public String release() {
        return this.release;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public Boolean includeAudit() {
        return this.includeAudit;
    }

    public static class Builder {
        private String assistantId;
        private String release;
        private String environmentId;
        private Boolean includeAudit;

        private Builder(DeployReleaseOptions deployReleaseOptions) {
            this.assistantId = deployReleaseOptions.assistantId;
            this.release = deployReleaseOptions.release;
            this.environmentId = deployReleaseOptions.environmentId;
            this.includeAudit = deployReleaseOptions.includeAudit;
        }

        public Builder() {
        }

        public Builder(String assistantId, String release, String environmentId) {
            this.assistantId = assistantId;
            this.release = release;
            this.environmentId = environmentId;
        }

        public DeployReleaseOptions build() {
            return new DeployReleaseOptions(this);
        }

        public Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public Builder release(String release) {
            this.release = release;
            return this;
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder includeAudit(Boolean includeAudit) {
            this.includeAudit = includeAudit;
            return this;
        }
    }
}

