/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v1.model.Counterexample;

public class CreateCounterexampleOptions
extends GenericModel {
    protected String workspaceId;
    protected String text;
    protected Boolean includeAudit;

    protected CreateCounterexampleOptions() {
    }

    protected CreateCounterexampleOptions(Builder builder) {
        Validator.notEmpty((String)builder.workspaceId, (String)"workspaceId cannot be empty");
        Validator.notNull((Object)builder.text, (String)"text cannot be null");
        this.workspaceId = builder.workspaceId;
        this.text = builder.text;
        this.includeAudit = builder.includeAudit;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String text() {
        return this.text;
    }

    public Boolean includeAudit() {
        return this.includeAudit;
    }

    public static class Builder {
        private String workspaceId;
        private String text;
        private Boolean includeAudit;

        private Builder(CreateCounterexampleOptions createCounterexampleOptions) {
            this.workspaceId = createCounterexampleOptions.workspaceId;
            this.text = createCounterexampleOptions.text;
            this.includeAudit = createCounterexampleOptions.includeAudit;
        }

        public Builder() {
        }

        public Builder(String workspaceId, String text) {
            this.workspaceId = workspaceId;
            this.text = text;
        }

        public CreateCounterexampleOptions build() {
            return new CreateCounterexampleOptions(this);
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder includeAudit(Boolean includeAudit) {
            this.includeAudit = includeAudit;
            return this;
        }

        public Builder counterexample(Counterexample counterexample) {
            this.text = counterexample.text();
            return this;
        }
    }
}

