/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.sdk.core.service.model.DynamicModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v1.model.DialogNodeOutputGeneric;
import com.ibm.watson.assistant.v1.model.DialogNodeOutputModifiers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DialogNodeOutput
extends DynamicModel<Object> {
    @SerializedName(value="generic")
    protected List<DialogNodeOutputGeneric> generic;
    @SerializedName(value="integrations")
    protected Map<String, Map<String, Object>> integrations;
    @SerializedName(value="modifiers")
    protected DialogNodeOutputModifiers modifiers;

    public DialogNodeOutput() {
        super((TypeToken)new TypeToken<Object>(){});
    }

    protected DialogNodeOutput(Builder builder) {
        super((TypeToken)new TypeToken<Object>(){});
        this.generic = builder.generic;
        this.integrations = builder.integrations;
        this.modifiers = builder.modifiers;
        this.setProperties(builder.dynamicProperties);
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public List<DialogNodeOutputGeneric> getGeneric() {
        return this.generic;
    }

    public void setGeneric(List<DialogNodeOutputGeneric> generic) {
        this.generic = generic;
    }

    public Map<String, Map<String, Object>> getIntegrations() {
        return this.integrations;
    }

    public void setIntegrations(Map<String, Map<String, Object>> integrations) {
        this.integrations = integrations;
    }

    public DialogNodeOutputModifiers getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(DialogNodeOutputModifiers modifiers) {
        this.modifiers = modifiers;
    }

    public static class Builder {
        private List<DialogNodeOutputGeneric> generic;
        private Map<String, Map<String, Object>> integrations;
        private DialogNodeOutputModifiers modifiers;
        private Map<String, Object> dynamicProperties;

        private Builder(DialogNodeOutput dialogNodeOutput) {
            this.generic = dialogNodeOutput.generic;
            this.integrations = dialogNodeOutput.integrations;
            this.modifiers = dialogNodeOutput.modifiers;
            this.dynamicProperties = dialogNodeOutput.getProperties();
        }

        public Builder() {
        }

        public DialogNodeOutput build() {
            return new DialogNodeOutput(this);
        }

        public Builder addGeneric(DialogNodeOutputGeneric generic) {
            Validator.notNull((Object)((Object)generic), (String)"generic cannot be null");
            if (this.generic == null) {
                this.generic = new ArrayList<DialogNodeOutputGeneric>();
            }
            this.generic.add(generic);
            return this;
        }

        public Builder generic(List<DialogNodeOutputGeneric> generic) {
            this.generic = generic;
            return this;
        }

        public Builder integrations(Map<String, Map<String, Object>> integrations) {
            this.integrations = integrations;
            return this;
        }

        public Builder modifiers(DialogNodeOutputModifiers modifiers) {
            this.modifiers = modifiers;
            return this;
        }

        public Builder add(String name, Object value) {
            Validator.notNull((Object)name, (String)"name cannot be null");
            if (this.dynamicProperties == null) {
                this.dynamicProperties = new HashMap<String, Object>();
            }
            this.dynamicProperties.put(name, value);
            return this;
        }
    }
}

