/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v1.model.DialogSuggestionValue;
import java.util.Map;

public class DialogSuggestion
extends GenericModel {
    protected String label;
    protected DialogSuggestionValue value;
    protected Map<String, Object> output;
    @SerializedName(value="dialog_node")
    protected String dialogNode;

    protected DialogSuggestion() {
    }

    protected DialogSuggestion(Builder builder) {
        Validator.notNull((Object)builder.label, (String)"label cannot be null");
        Validator.notNull((Object)((Object)builder.value), (String)"value cannot be null");
        this.label = builder.label;
        this.value = builder.value;
        this.output = builder.output;
        this.dialogNode = builder.dialogNode;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String label() {
        return this.label;
    }

    public DialogSuggestionValue value() {
        return this.value;
    }

    public Map<String, Object> output() {
        return this.output;
    }

    public String dialogNode() {
        return this.dialogNode;
    }

    public static class Builder {
        private String label;
        private DialogSuggestionValue value;
        private Map<String, Object> output;
        private String dialogNode;

        private Builder(DialogSuggestion dialogSuggestion) {
            this.label = dialogSuggestion.label;
            this.value = dialogSuggestion.value;
            this.output = dialogSuggestion.output;
            this.dialogNode = dialogSuggestion.dialogNode;
        }

        public Builder() {
        }

        public Builder(String label, DialogSuggestionValue value) {
            this.label = label;
            this.value = value;
        }

        public DialogSuggestion build() {
            return new DialogSuggestion(this);
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder value(DialogSuggestionValue value) {
            this.value = value;
            return this;
        }

        public Builder output(Map<String, Object> output) {
            this.output = output;
            return this;
        }

        public Builder dialogNode(String dialogNode) {
            this.dialogNode = dialogNode;
            return this;
        }
    }
}

