/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class ListValuesOptions
extends GenericModel {
    protected String workspaceId;
    protected String entity;
    protected Boolean export;
    protected Long pageLimit;
    protected Boolean includeCount;
    protected String sort;
    protected String cursor;
    protected Boolean includeAudit;

    protected ListValuesOptions() {
    }

    protected ListValuesOptions(Builder builder) {
        Validator.notEmpty((String)builder.workspaceId, (String)"workspaceId cannot be empty");
        Validator.notEmpty((String)builder.entity, (String)"entity cannot be empty");
        this.workspaceId = builder.workspaceId;
        this.entity = builder.entity;
        this.export = builder.export;
        this.pageLimit = builder.pageLimit;
        this.includeCount = builder.includeCount;
        this.sort = builder.sort;
        this.cursor = builder.cursor;
        this.includeAudit = builder.includeAudit;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String entity() {
        return this.entity;
    }

    public Boolean export() {
        return this.export;
    }

    public Long pageLimit() {
        return this.pageLimit;
    }

    public Boolean includeCount() {
        return this.includeCount;
    }

    public String sort() {
        return this.sort;
    }

    public String cursor() {
        return this.cursor;
    }

    public Boolean includeAudit() {
        return this.includeAudit;
    }

    public static class Builder {
        private String workspaceId;
        private String entity;
        private Boolean export;
        private Long pageLimit;
        private Boolean includeCount;
        private String sort;
        private String cursor;
        private Boolean includeAudit;

        private Builder(ListValuesOptions listValuesOptions) {
            this.workspaceId = listValuesOptions.workspaceId;
            this.entity = listValuesOptions.entity;
            this.export = listValuesOptions.export;
            this.pageLimit = listValuesOptions.pageLimit;
            this.includeCount = listValuesOptions.includeCount;
            this.sort = listValuesOptions.sort;
            this.cursor = listValuesOptions.cursor;
            this.includeAudit = listValuesOptions.includeAudit;
        }

        public Builder() {
        }

        public Builder(String workspaceId, String entity) {
            this.workspaceId = workspaceId;
            this.entity = entity;
        }

        public ListValuesOptions build() {
            return new ListValuesOptions(this);
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder entity(String entity) {
            this.entity = entity;
            return this;
        }

        public Builder export(Boolean export) {
            this.export = export;
            return this;
        }

        public Builder pageLimit(long pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }

        public Builder includeCount(Boolean includeCount) {
            this.includeCount = includeCount;
            return this;
        }

        public Builder sort(String sort) {
            this.sort = sort;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder includeAudit(Boolean includeAudit) {
            this.includeAudit = includeAudit;
            return this;
        }
    }

    public static interface Sort {
        public static final String VALUE = "value";
        public static final String UPDATED = "updated";
    }
}

