/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UpdateValueOptions
extends GenericModel {
    protected String workspaceId;
    protected String entity;
    protected String value;
    protected String newValue;
    protected Map<String, Object> newMetadata;
    protected String newType;
    protected List<String> newSynonyms;
    protected List<String> newPatterns;
    protected Boolean append;
    protected Boolean includeAudit;

    protected UpdateValueOptions() {
    }

    protected UpdateValueOptions(Builder builder) {
        Validator.notEmpty((String)builder.workspaceId, (String)"workspaceId cannot be empty");
        Validator.notEmpty((String)builder.entity, (String)"entity cannot be empty");
        Validator.notEmpty((String)builder.value, (String)"value cannot be empty");
        this.workspaceId = builder.workspaceId;
        this.entity = builder.entity;
        this.value = builder.value;
        this.newValue = builder.newValue;
        this.newMetadata = builder.newMetadata;
        this.newType = builder.newType;
        this.newSynonyms = builder.newSynonyms;
        this.newPatterns = builder.newPatterns;
        this.append = builder.append;
        this.includeAudit = builder.includeAudit;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String entity() {
        return this.entity;
    }

    public String value() {
        return this.value;
    }

    public String newValue() {
        return this.newValue;
    }

    public Map<String, Object> newMetadata() {
        return this.newMetadata;
    }

    public String newType() {
        return this.newType;
    }

    public List<String> newSynonyms() {
        return this.newSynonyms;
    }

    public List<String> newPatterns() {
        return this.newPatterns;
    }

    public Boolean append() {
        return this.append;
    }

    public Boolean includeAudit() {
        return this.includeAudit;
    }

    public static class Builder {
        private String workspaceId;
        private String entity;
        private String value;
        private String newValue;
        private Map<String, Object> newMetadata;
        private String newType;
        private List<String> newSynonyms;
        private List<String> newPatterns;
        private Boolean append;
        private Boolean includeAudit;

        private Builder(UpdateValueOptions updateValueOptions) {
            this.workspaceId = updateValueOptions.workspaceId;
            this.entity = updateValueOptions.entity;
            this.value = updateValueOptions.value;
            this.newValue = updateValueOptions.newValue;
            this.newMetadata = updateValueOptions.newMetadata;
            this.newType = updateValueOptions.newType;
            this.newSynonyms = updateValueOptions.newSynonyms;
            this.newPatterns = updateValueOptions.newPatterns;
            this.append = updateValueOptions.append;
            this.includeAudit = updateValueOptions.includeAudit;
        }

        public Builder() {
        }

        public Builder(String workspaceId, String entity, String value) {
            this.workspaceId = workspaceId;
            this.entity = entity;
            this.value = value;
        }

        public UpdateValueOptions build() {
            return new UpdateValueOptions(this);
        }

        public Builder addSynonym(String synonym) {
            Validator.notNull((Object)synonym, (String)"synonym cannot be null");
            if (this.newSynonyms == null) {
                this.newSynonyms = new ArrayList<String>();
            }
            this.newSynonyms.add(synonym);
            return this;
        }

        public Builder addPattern(String pattern) {
            Validator.notNull((Object)pattern, (String)"pattern cannot be null");
            if (this.newPatterns == null) {
                this.newPatterns = new ArrayList<String>();
            }
            this.newPatterns.add(pattern);
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder entity(String entity) {
            this.entity = entity;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder newValue(String newValue) {
            this.newValue = newValue;
            return this;
        }

        public Builder newMetadata(Map<String, Object> newMetadata) {
            this.newMetadata = newMetadata;
            return this;
        }

        public Builder newType(String newType) {
            this.newType = newType;
            return this;
        }

        public Builder newSynonyms(List<String> newSynonyms) {
            this.newSynonyms = newSynonyms;
            return this;
        }

        public Builder newPatterns(List<String> newPatterns) {
            this.newPatterns = newPatterns;
            return this;
        }

        public Builder append(Boolean append) {
            this.append = append;
            return this;
        }

        public Builder includeAudit(Boolean includeAudit) {
            this.includeAudit = includeAudit;
            return this;
        }
    }

    public static interface NewType {
        public static final String SYNONYMS = "synonyms";
        public static final String PATTERNS = "patterns";
    }
}

