/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class EnvironmentSkill
extends GenericModel {
    @SerializedName(value="skill_id")
    protected String skillId;
    protected String type;
    protected Boolean disabled;
    protected String snapshot;
    @SerializedName(value="skill_reference")
    protected String skillReference;

    protected EnvironmentSkill() {
    }

    protected EnvironmentSkill(Builder builder) {
        Validator.notNull((Object)builder.skillId, (String)"skillId cannot be null");
        this.skillId = builder.skillId;
        this.type = builder.type;
        this.disabled = builder.disabled;
        this.snapshot = builder.snapshot;
        this.skillReference = builder.skillReference;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String skillId() {
        return this.skillId;
    }

    public String type() {
        return this.type;
    }

    public Boolean disabled() {
        return this.disabled;
    }

    public String snapshot() {
        return this.snapshot;
    }

    public String skillReference() {
        return this.skillReference;
    }

    public static class Builder {
        private String skillId;
        private String type;
        private Boolean disabled;
        private String snapshot;
        private String skillReference;

        private Builder(EnvironmentSkill environmentSkill) {
            this.skillId = environmentSkill.skillId;
            this.type = environmentSkill.type;
            this.disabled = environmentSkill.disabled;
            this.snapshot = environmentSkill.snapshot;
            this.skillReference = environmentSkill.skillReference;
        }

        public Builder() {
        }

        public Builder(String skillId) {
            this.skillId = skillId;
        }

        public EnvironmentSkill build() {
            return new EnvironmentSkill(this);
        }

        public Builder skillId(String skillId) {
            this.skillId = skillId;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public Builder snapshot(String snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        public Builder skillReference(String skillReference) {
            this.skillReference = skillReference;
            return this;
        }
    }

    public static interface Type {
        public static final String DIALOG = "dialog";
        public static final String ACTION = "action";
        public static final String SEARCH = "search";
    }
}

