/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class ListLogsOptions
extends GenericModel {
    protected String assistantId;
    protected String sort;
    protected String filter;
    protected Long pageLimit;
    protected String cursor;

    protected ListLogsOptions() {
    }

    protected ListLogsOptions(Builder builder) {
        Validator.notEmpty((String)builder.assistantId, (String)"assistantId cannot be empty");
        this.assistantId = builder.assistantId;
        this.sort = builder.sort;
        this.filter = builder.filter;
        this.pageLimit = builder.pageLimit;
        this.cursor = builder.cursor;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String assistantId() {
        return this.assistantId;
    }

    public String sort() {
        return this.sort;
    }

    public String filter() {
        return this.filter;
    }

    public Long pageLimit() {
        return this.pageLimit;
    }

    public String cursor() {
        return this.cursor;
    }

    public static class Builder {
        private String assistantId;
        private String sort;
        private String filter;
        private Long pageLimit;
        private String cursor;

        private Builder(ListLogsOptions listLogsOptions) {
            this.assistantId = listLogsOptions.assistantId;
            this.sort = listLogsOptions.sort;
            this.filter = listLogsOptions.filter;
            this.pageLimit = listLogsOptions.pageLimit;
            this.cursor = listLogsOptions.cursor;
        }

        public Builder() {
        }

        public Builder(String assistantId) {
            this.assistantId = assistantId;
        }

        public ListLogsOptions build() {
            return new ListLogsOptions(this);
        }

        public Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public Builder sort(String sort) {
            this.sort = sort;
            return this;
        }

        public Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder pageLimit(long pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }
    }
}

