/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v2.model.MessageInputAttachment;
import com.ibm.watson.assistant.v2.model.MessageInputOptions;
import com.ibm.watson.assistant.v2.model.RequestAnalytics;
import com.ibm.watson.assistant.v2.model.RuntimeEntity;
import com.ibm.watson.assistant.v2.model.RuntimeIntent;
import java.util.ArrayList;
import java.util.List;

public class LogRequestInput
extends GenericModel {
    @SerializedName(value="message_type")
    protected String messageType;
    protected String text;
    protected List<RuntimeIntent> intents;
    protected List<RuntimeEntity> entities;
    @SerializedName(value="suggestion_id")
    protected String suggestionId;
    protected List<MessageInputAttachment> attachments;
    protected RequestAnalytics analytics;
    protected MessageInputOptions options;

    protected LogRequestInput() {
    }

    protected LogRequestInput(Builder builder) {
        this.messageType = builder.messageType;
        this.text = builder.text;
        this.intents = builder.intents;
        this.entities = builder.entities;
        this.suggestionId = builder.suggestionId;
        this.attachments = builder.attachments;
        this.analytics = builder.analytics;
        this.options = builder.options;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String messageType() {
        return this.messageType;
    }

    public String text() {
        return this.text;
    }

    public List<RuntimeIntent> intents() {
        return this.intents;
    }

    public List<RuntimeEntity> entities() {
        return this.entities;
    }

    public String suggestionId() {
        return this.suggestionId;
    }

    public List<MessageInputAttachment> attachments() {
        return this.attachments;
    }

    public RequestAnalytics analytics() {
        return this.analytics;
    }

    public MessageInputOptions options() {
        return this.options;
    }

    public static class Builder {
        private String messageType;
        private String text;
        private List<RuntimeIntent> intents;
        private List<RuntimeEntity> entities;
        private String suggestionId;
        private List<MessageInputAttachment> attachments;
        private RequestAnalytics analytics;
        private MessageInputOptions options;

        private Builder(LogRequestInput logRequestInput) {
            this.messageType = logRequestInput.messageType;
            this.text = logRequestInput.text;
            this.intents = logRequestInput.intents;
            this.entities = logRequestInput.entities;
            this.suggestionId = logRequestInput.suggestionId;
            this.attachments = logRequestInput.attachments;
            this.analytics = logRequestInput.analytics;
            this.options = logRequestInput.options;
        }

        public Builder() {
        }

        public LogRequestInput build() {
            return new LogRequestInput(this);
        }

        public Builder addIntent(RuntimeIntent intent) {
            Validator.notNull((Object)((Object)intent), (String)"intent cannot be null");
            if (this.intents == null) {
                this.intents = new ArrayList<RuntimeIntent>();
            }
            this.intents.add(intent);
            return this;
        }

        public Builder addEntity(RuntimeEntity entity) {
            Validator.notNull((Object)((Object)entity), (String)"entity cannot be null");
            if (this.entities == null) {
                this.entities = new ArrayList<RuntimeEntity>();
            }
            this.entities.add(entity);
            return this;
        }

        public Builder addAttachments(MessageInputAttachment attachments) {
            Validator.notNull((Object)((Object)attachments), (String)"attachments cannot be null");
            if (this.attachments == null) {
                this.attachments = new ArrayList<MessageInputAttachment>();
            }
            this.attachments.add(attachments);
            return this;
        }

        public Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder intents(List<RuntimeIntent> intents) {
            this.intents = intents;
            return this;
        }

        public Builder entities(List<RuntimeEntity> entities) {
            this.entities = entities;
            return this;
        }

        public Builder suggestionId(String suggestionId) {
            this.suggestionId = suggestionId;
            return this;
        }

        public Builder attachments(List<MessageInputAttachment> attachments) {
            this.attachments = attachments;
            return this;
        }

        public Builder analytics(RequestAnalytics analytics) {
            this.analytics = analytics;
            return this;
        }

        public Builder options(MessageInputOptions options) {
            this.options = options;
            return this;
        }
    }

    public static interface MessageType {
        public static final String TEXT = "text";
        public static final String SEARCH = "search";
    }
}

