/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v2.model.BaseEnvironmentOrchestration;
import com.ibm.watson.assistant.v2.model.EnvironmentSkill;
import java.util.ArrayList;
import java.util.List;

public class UpdateEnvironmentOptions
extends GenericModel {
    protected String assistantId;
    protected String environmentId;
    protected String name;
    protected String description;
    protected BaseEnvironmentOrchestration orchestration;
    protected Long sessionTimeout;
    protected List<EnvironmentSkill> skillReferences;

    protected UpdateEnvironmentOptions() {
    }

    protected UpdateEnvironmentOptions(Builder builder) {
        Validator.notEmpty((String)builder.assistantId, (String)"assistantId cannot be empty");
        Validator.notEmpty((String)builder.environmentId, (String)"environmentId cannot be empty");
        this.assistantId = builder.assistantId;
        this.environmentId = builder.environmentId;
        this.name = builder.name;
        this.description = builder.description;
        this.orchestration = builder.orchestration;
        this.sessionTimeout = builder.sessionTimeout;
        this.skillReferences = builder.skillReferences;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String assistantId() {
        return this.assistantId;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public BaseEnvironmentOrchestration orchestration() {
        return this.orchestration;
    }

    public Long sessionTimeout() {
        return this.sessionTimeout;
    }

    public List<EnvironmentSkill> skillReferences() {
        return this.skillReferences;
    }

    public static class Builder {
        private String assistantId;
        private String environmentId;
        private String name;
        private String description;
        private BaseEnvironmentOrchestration orchestration;
        private Long sessionTimeout;
        private List<EnvironmentSkill> skillReferences;

        private Builder(UpdateEnvironmentOptions updateEnvironmentOptions) {
            this.assistantId = updateEnvironmentOptions.assistantId;
            this.environmentId = updateEnvironmentOptions.environmentId;
            this.name = updateEnvironmentOptions.name;
            this.description = updateEnvironmentOptions.description;
            this.orchestration = updateEnvironmentOptions.orchestration;
            this.sessionTimeout = updateEnvironmentOptions.sessionTimeout;
            this.skillReferences = updateEnvironmentOptions.skillReferences;
        }

        public Builder() {
        }

        public Builder(String assistantId, String environmentId) {
            this.assistantId = assistantId;
            this.environmentId = environmentId;
        }

        public UpdateEnvironmentOptions build() {
            return new UpdateEnvironmentOptions(this);
        }

        public Builder addSkillReference(EnvironmentSkill skillReference) {
            Validator.notNull((Object)((Object)skillReference), (String)"skillReference cannot be null");
            if (this.skillReferences == null) {
                this.skillReferences = new ArrayList<EnvironmentSkill>();
            }
            this.skillReferences.add(skillReference);
            return this;
        }

        public Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder orchestration(BaseEnvironmentOrchestration orchestration) {
            this.orchestration = orchestration;
            return this;
        }

        public Builder sessionTimeout(long sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
            return this;
        }

        public Builder skillReferences(List<EnvironmentSkill> skillReferences) {
            this.skillReferences = skillReferences;
            return this;
        }
    }
}

