/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v1.model.CreateValue;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class CreateEntity
extends GenericModel {
    protected String entity;
    protected String description;
    protected Map<String, Object> metadata;
    @SerializedName(value="fuzzy_match")
    protected Boolean fuzzyMatch;
    protected Date created;
    protected Date updated;
    protected List<CreateValue> values;

    protected CreateEntity() {
    }

    protected CreateEntity(Builder builder) {
        Validator.notNull((Object)builder.entity, (String)"entity cannot be null");
        this.entity = builder.entity;
        this.description = builder.description;
        this.metadata = builder.metadata;
        this.fuzzyMatch = builder.fuzzyMatch;
        this.values = builder.values;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String entity() {
        return this.entity;
    }

    public String description() {
        return this.description;
    }

    public Map<String, Object> metadata() {
        return this.metadata;
    }

    public Boolean fuzzyMatch() {
        return this.fuzzyMatch;
    }

    public Date created() {
        return this.created;
    }

    public Date updated() {
        return this.updated;
    }

    public List<CreateValue> values() {
        return this.values;
    }

    public static class Builder {
        private String entity;
        private String description;
        private Map<String, Object> metadata;
        private Boolean fuzzyMatch;
        private List<CreateValue> values;

        private Builder(CreateEntity createEntity) {
            this.entity = createEntity.entity;
            this.description = createEntity.description;
            this.metadata = createEntity.metadata;
            this.fuzzyMatch = createEntity.fuzzyMatch;
            this.values = createEntity.values;
        }

        public Builder() {
        }

        public Builder(String entity) {
            this.entity = entity;
        }

        public CreateEntity build() {
            return new CreateEntity(this);
        }

        public Builder addValues(CreateValue values) {
            Validator.notNull((Object)((Object)values), (String)"values cannot be null");
            if (this.values == null) {
                this.values = new ArrayList<CreateValue>();
            }
            this.values.add(values);
            return this;
        }

        public Builder entity(String entity) {
            this.entity = entity;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder fuzzyMatch(Boolean fuzzyMatch) {
            this.fuzzyMatch = fuzzyMatch;
            return this;
        }

        public Builder values(List<CreateValue> values) {
            this.values = values;
            return this;
        }
    }
}

