/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v2.model.AssistantCollection;
import com.ibm.watson.assistant.v2.model.AssistantData;
import com.ibm.watson.assistant.v2.model.BulkClassifyOptions;
import com.ibm.watson.assistant.v2.model.BulkClassifyResponse;
import com.ibm.watson.assistant.v2.model.CreateAssistantOptions;
import com.ibm.watson.assistant.v2.model.CreateAssistantReleaseImportResponse;
import com.ibm.watson.assistant.v2.model.CreateProviderOptions;
import com.ibm.watson.assistant.v2.model.CreateReleaseExportOptions;
import com.ibm.watson.assistant.v2.model.CreateReleaseExportWithStatusErrors;
import com.ibm.watson.assistant.v2.model.CreateReleaseImportOptions;
import com.ibm.watson.assistant.v2.model.CreateReleaseOptions;
import com.ibm.watson.assistant.v2.model.CreateSessionOptions;
import com.ibm.watson.assistant.v2.model.DeleteAssistantOptions;
import com.ibm.watson.assistant.v2.model.DeleteReleaseOptions;
import com.ibm.watson.assistant.v2.model.DeleteSessionOptions;
import com.ibm.watson.assistant.v2.model.DeleteUserDataOptions;
import com.ibm.watson.assistant.v2.model.DeployReleaseOptions;
import com.ibm.watson.assistant.v2.model.DownloadReleaseExportOptions;
import com.ibm.watson.assistant.v2.model.Environment;
import com.ibm.watson.assistant.v2.model.EnvironmentCollection;
import com.ibm.watson.assistant.v2.model.ExportSkillsOptions;
import com.ibm.watson.assistant.v2.model.GetEnvironmentOptions;
import com.ibm.watson.assistant.v2.model.GetReleaseImportStatusOptions;
import com.ibm.watson.assistant.v2.model.GetReleaseOptions;
import com.ibm.watson.assistant.v2.model.GetSkillOptions;
import com.ibm.watson.assistant.v2.model.ImportSkillsOptions;
import com.ibm.watson.assistant.v2.model.ImportSkillsStatusOptions;
import com.ibm.watson.assistant.v2.model.ListAssistantsOptions;
import com.ibm.watson.assistant.v2.model.ListEnvironmentsOptions;
import com.ibm.watson.assistant.v2.model.ListLogsOptions;
import com.ibm.watson.assistant.v2.model.ListProvidersOptions;
import com.ibm.watson.assistant.v2.model.ListReleasesOptions;
import com.ibm.watson.assistant.v2.model.LogCollection;
import com.ibm.watson.assistant.v2.model.MessageOptions;
import com.ibm.watson.assistant.v2.model.MessageStatelessOptions;
import com.ibm.watson.assistant.v2.model.MessageStreamOptions;
import com.ibm.watson.assistant.v2.model.MessageStreamStatelessOptions;
import com.ibm.watson.assistant.v2.model.MonitorAssistantReleaseImportArtifactResponse;
import com.ibm.watson.assistant.v2.model.ProviderCollection;
import com.ibm.watson.assistant.v2.model.ProviderResponse;
import com.ibm.watson.assistant.v2.model.Release;
import com.ibm.watson.assistant.v2.model.ReleaseCollection;
import com.ibm.watson.assistant.v2.model.SessionResponse;
import com.ibm.watson.assistant.v2.model.Skill;
import com.ibm.watson.assistant.v2.model.SkillsAsyncRequestStatus;
import com.ibm.watson.assistant.v2.model.SkillsExport;
import com.ibm.watson.assistant.v2.model.StatefulMessageResponse;
import com.ibm.watson.assistant.v2.model.StatelessMessageResponse;
import com.ibm.watson.assistant.v2.model.UpdateEnvironmentOptions;
import com.ibm.watson.assistant.v2.model.UpdateProviderOptions;
import com.ibm.watson.assistant.v2.model.UpdateSkillOptions;
import com.ibm.watson.common.SdkCommon;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;

public class Assistant
extends BaseService {
    public static final String DEFAULT_SERVICE_NAME = "assistant";
    public static final String DEFAULT_SERVICE_URL = "https://api.us-south.assistant.watson.cloud.ibm.com";
    private String version;

    public Assistant(String version) {
        this(version, DEFAULT_SERVICE_NAME, ConfigBasedAuthenticatorFactory.getAuthenticator((String)DEFAULT_SERVICE_NAME));
    }

    public Assistant(String version, Authenticator authenticator) {
        this(version, DEFAULT_SERVICE_NAME, authenticator);
    }

    public Assistant(String version, String serviceName) {
        this(version, serviceName, ConfigBasedAuthenticatorFactory.getAuthenticator((String)serviceName));
    }

    public Assistant(String version, String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
        this.setServiceUrl(DEFAULT_SERVICE_URL);
        this.setVersion(version);
        this.configureService(serviceName);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        Validator.notEmpty((String)version, (String)"version cannot be empty.");
        this.version = version;
    }

    public ServiceCall<ProviderResponse> createProvider(CreateProviderOptions createProviderOptions) {
        Validator.notNull((Object)((Object)createProviderOptions), (String)"createProviderOptions cannot be null");
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/providers"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"createProvider");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("provider_id", createProviderOptions.providerId());
        contentJson.add("specification", GsonSingleton.getGson().toJsonTree((Object)createProviderOptions.specification()));
        contentJson.add("private", GsonSingleton.getGson().toJsonTree((Object)createProviderOptions.xPrivate()));
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ProviderResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ProviderCollection> listProviders(ListProvidersOptions listProvidersOptions) {
        if (listProvidersOptions == null) {
            listProvidersOptions = new ListProvidersOptions.Builder().build();
        }
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/providers"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"listProviders");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (listProvidersOptions.pageLimit() != null) {
            builder.query(new Object[]{"page_limit", String.valueOf(listProvidersOptions.pageLimit())});
        }
        if (listProvidersOptions.includeCount() != null) {
            builder.query(new Object[]{"include_count", String.valueOf(listProvidersOptions.includeCount())});
        }
        if (listProvidersOptions.sort() != null) {
            builder.query(new Object[]{"sort", String.valueOf(listProvidersOptions.sort())});
        }
        if (listProvidersOptions.cursor() != null) {
            builder.query(new Object[]{"cursor", String.valueOf(listProvidersOptions.cursor())});
        }
        if (listProvidersOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(listProvidersOptions.includeAudit())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ProviderCollection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ProviderCollection> listProviders() {
        return this.listProviders(null);
    }

    public ServiceCall<ProviderResponse> updateProvider(UpdateProviderOptions updateProviderOptions) {
        Validator.notNull((Object)((Object)updateProviderOptions), (String)"updateProviderOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("provider_id", updateProviderOptions.providerId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/providers/{provider_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"updateProvider");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        JsonObject contentJson = new JsonObject();
        contentJson.add("specification", GsonSingleton.getGson().toJsonTree((Object)updateProviderOptions.specification()));
        contentJson.add("private", GsonSingleton.getGson().toJsonTree((Object)updateProviderOptions.xPrivate()));
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ProviderResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AssistantData> createAssistant(CreateAssistantOptions createAssistantOptions) {
        boolean skipBody = false;
        if (createAssistantOptions == null) {
            createAssistantOptions = new CreateAssistantOptions.Builder().build();
            skipBody = true;
        }
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"createAssistant");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (!skipBody) {
            JsonObject contentJson = new JsonObject();
            if (createAssistantOptions.name() != null) {
                contentJson.addProperty("name", createAssistantOptions.name());
            }
            if (createAssistantOptions.description() != null) {
                contentJson.addProperty("description", createAssistantOptions.description());
            }
            if (createAssistantOptions.language() != null) {
                contentJson.addProperty("language", createAssistantOptions.language());
            }
            builder.bodyJson(contentJson);
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<AssistantData>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AssistantData> createAssistant() {
        return this.createAssistant(null);
    }

    public ServiceCall<AssistantCollection> listAssistants(ListAssistantsOptions listAssistantsOptions) {
        if (listAssistantsOptions == null) {
            listAssistantsOptions = new ListAssistantsOptions.Builder().build();
        }
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"listAssistants");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (listAssistantsOptions.pageLimit() != null) {
            builder.query(new Object[]{"page_limit", String.valueOf(listAssistantsOptions.pageLimit())});
        }
        if (listAssistantsOptions.includeCount() != null) {
            builder.query(new Object[]{"include_count", String.valueOf(listAssistantsOptions.includeCount())});
        }
        if (listAssistantsOptions.sort() != null) {
            builder.query(new Object[]{"sort", String.valueOf(listAssistantsOptions.sort())});
        }
        if (listAssistantsOptions.cursor() != null) {
            builder.query(new Object[]{"cursor", String.valueOf(listAssistantsOptions.cursor())});
        }
        if (listAssistantsOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(listAssistantsOptions.includeAudit())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<AssistantCollection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AssistantCollection> listAssistants() {
        return this.listAssistants(null);
    }

    public ServiceCall<Void> deleteAssistant(DeleteAssistantOptions deleteAssistantOptions) {
        Validator.notNull((Object)((Object)deleteAssistantOptions), (String)"deleteAssistantOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("assistant_id", deleteAssistantOptions.assistantId());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants/{assistant_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"deleteAssistant");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SessionResponse> createSession(CreateSessionOptions createSessionOptions) {
        Validator.notNull((Object)((Object)createSessionOptions), (String)"createSessionOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("assistant_id", createSessionOptions.assistantId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants/{assistant_id}/sessions", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"createSession");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        JsonObject contentJson = new JsonObject();
        if (createSessionOptions.analytics() != null) {
            contentJson.add("analytics", GsonSingleton.getGson().toJsonTree((Object)createSessionOptions.analytics()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SessionResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteSession(DeleteSessionOptions deleteSessionOptions) {
        Validator.notNull((Object)((Object)deleteSessionOptions), (String)"deleteSessionOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("assistant_id", deleteSessionOptions.assistantId());
        pathParamsMap.put("session_id", deleteSessionOptions.sessionId());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants/{assistant_id}/sessions/{session_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"deleteSession");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<StatefulMessageResponse> message(MessageOptions messageOptions) {
        Validator.notNull((Object)((Object)messageOptions), (String)"messageOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("assistant_id", messageOptions.assistantId());
        pathParamsMap.put("environment_id", messageOptions.environmentId());
        pathParamsMap.put("session_id", messageOptions.sessionId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants/{assistant_id}/sessions/{session_id}/message", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"message");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        JsonObject contentJson = new JsonObject();
        if (messageOptions.input() != null) {
            contentJson.add("input", GsonSingleton.getGson().toJsonTree((Object)messageOptions.input()));
        }
        if (messageOptions.context() != null) {
            contentJson.add("context", GsonSingleton.getGson().toJsonTree((Object)messageOptions.context()));
        }
        if (messageOptions.userId() != null) {
            contentJson.addProperty("user_id", messageOptions.userId());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<StatefulMessageResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<StatelessMessageResponse> messageStateless(MessageStatelessOptions messageStatelessOptions) {
        Validator.notNull((Object)((Object)messageStatelessOptions), (String)"messageStatelessOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("assistant_id", messageStatelessOptions.assistantId());
        pathParamsMap.put("environment_id", messageStatelessOptions.environmentId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants/{assistant_id}/message", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"messageStateless");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        JsonObject contentJson = new JsonObject();
        if (messageStatelessOptions.input() != null) {
            contentJson.add("input", GsonSingleton.getGson().toJsonTree((Object)messageStatelessOptions.input()));
        }
        if (messageStatelessOptions.context() != null) {
            contentJson.add("context", GsonSingleton.getGson().toJsonTree((Object)messageStatelessOptions.context()));
        }
        if (messageStatelessOptions.userId() != null) {
            contentJson.addProperty("user_id", messageStatelessOptions.userId());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<StatelessMessageResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> messageStream(MessageStreamOptions messageStreamOptions) {
        Validator.notNull((Object)((Object)messageStreamOptions), (String)"messageStreamOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("assistant_id", messageStreamOptions.assistantId());
        pathParamsMap.put("environment_id", messageStreamOptions.environmentId());
        pathParamsMap.put("session_id", messageStreamOptions.sessionId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants/{assistant_id}/environments/{environment_id}/sessions/{session_id}/message_stream", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"messageStream");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "text/event-stream"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        JsonObject contentJson = new JsonObject();
        if (messageStreamOptions.input() != null) {
            contentJson.add("input", GsonSingleton.getGson().toJsonTree((Object)messageStreamOptions.input()));
        }
        if (messageStreamOptions.context() != null) {
            contentJson.add("context", GsonSingleton.getGson().toJsonTree((Object)messageStreamOptions.context()));
        }
        if (messageStreamOptions.userId() != null) {
            contentJson.addProperty("user_id", messageStreamOptions.userId());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> messageStreamStateless(MessageStreamStatelessOptions messageStreamStatelessOptions) {
        Validator.notNull((Object)((Object)messageStreamStatelessOptions), (String)"messageStreamStatelessOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("assistant_id", messageStreamStatelessOptions.assistantId());
        pathParamsMap.put("environment_id", messageStreamStatelessOptions.environmentId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants/{assistant_id}/environments/{environment_id}/message_stream", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"messageStreamStateless");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "text/event-stream"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        JsonObject contentJson = new JsonObject();
        if (messageStreamStatelessOptions.input() != null) {
            contentJson.add("input", GsonSingleton.getGson().toJsonTree((Object)messageStreamStatelessOptions.input()));
        }
        if (messageStreamStatelessOptions.context() != null) {
            contentJson.add("context", GsonSingleton.getGson().toJsonTree((Object)messageStreamStatelessOptions.context()));
        }
        if (messageStreamStatelessOptions.userId() != null) {
            contentJson.addProperty("user_id", messageStreamStatelessOptions.userId());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<BulkClassifyResponse> bulkClassify(BulkClassifyOptions bulkClassifyOptions) {
        Validator.notNull((Object)((Object)bulkClassifyOptions), (String)"bulkClassifyOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("skill_id", bulkClassifyOptions.skillId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/skills/{skill_id}/workspace/bulk_classify", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"bulkClassify");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        JsonObject contentJson = new JsonObject();
        contentJson.add("input", GsonSingleton.getGson().toJsonTree(bulkClassifyOptions.input()));
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<BulkClassifyResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<LogCollection> listLogs(ListLogsOptions listLogsOptions) {
        Validator.notNull((Object)((Object)listLogsOptions), (String)"listLogsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("assistant_id", listLogsOptions.assistantId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants/{assistant_id}/logs", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"listLogs");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (listLogsOptions.sort() != null) {
            builder.query(new Object[]{"sort", String.valueOf(listLogsOptions.sort())});
        }
        if (listLogsOptions.filter() != null) {
            builder.query(new Object[]{"filter", String.valueOf(listLogsOptions.filter())});
        }
        if (listLogsOptions.pageLimit() != null) {
            builder.query(new Object[]{"page_limit", String.valueOf(listLogsOptions.pageLimit())});
        }
        if (listLogsOptions.cursor() != null) {
            builder.query(new Object[]{"cursor", String.valueOf(listLogsOptions.cursor())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<LogCollection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteUserData(DeleteUserDataOptions deleteUserDataOptions) {
        Validator.notNull((Object)((Object)deleteUserDataOptions), (String)"deleteUserDataOptions cannot be null");
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/user_data"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"deleteUserData");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        builder.query(new Object[]{"customer_id", String.valueOf(deleteUserDataOptions.customerId())});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<EnvironmentCollection> listEnvironments(ListEnvironmentsOptions listEnvironmentsOptions) {
        Validator.notNull((Object)((Object)listEnvironmentsOptions), (String)"listEnvironmentsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("assistant_id", listEnvironmentsOptions.assistantId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants/{assistant_id}/environments", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"listEnvironments");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (listEnvironmentsOptions.pageLimit() != null) {
            builder.query(new Object[]{"page_limit", String.valueOf(listEnvironmentsOptions.pageLimit())});
        }
        if (listEnvironmentsOptions.includeCount() != null) {
            builder.query(new Object[]{"include_count", String.valueOf(listEnvironmentsOptions.includeCount())});
        }
        if (listEnvironmentsOptions.sort() != null) {
            builder.query(new Object[]{"sort", String.valueOf(listEnvironmentsOptions.sort())});
        }
        if (listEnvironmentsOptions.cursor() != null) {
            builder.query(new Object[]{"cursor", String.valueOf(listEnvironmentsOptions.cursor())});
        }
        if (listEnvironmentsOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(listEnvironmentsOptions.includeAudit())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<EnvironmentCollection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Environment> getEnvironment(GetEnvironmentOptions getEnvironmentOptions) {
        Validator.notNull((Object)((Object)getEnvironmentOptions), (String)"getEnvironmentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("assistant_id", getEnvironmentOptions.assistantId());
        pathParamsMap.put("environment_id", getEnvironmentOptions.environmentId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants/{assistant_id}/environments/{environment_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"getEnvironment");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (getEnvironmentOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(getEnvironmentOptions.includeAudit())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Environment>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Environment> updateEnvironment(UpdateEnvironmentOptions updateEnvironmentOptions) {
        Validator.notNull((Object)((Object)updateEnvironmentOptions), (String)"updateEnvironmentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("assistant_id", updateEnvironmentOptions.assistantId());
        pathParamsMap.put("environment_id", updateEnvironmentOptions.environmentId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants/{assistant_id}/environments/{environment_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"updateEnvironment");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        JsonObject contentJson = new JsonObject();
        if (updateEnvironmentOptions.name() != null) {
            contentJson.addProperty("name", updateEnvironmentOptions.name());
        }
        if (updateEnvironmentOptions.description() != null) {
            contentJson.addProperty("description", updateEnvironmentOptions.description());
        }
        if (updateEnvironmentOptions.orchestration() != null) {
            contentJson.add("orchestration", GsonSingleton.getGson().toJsonTree((Object)updateEnvironmentOptions.orchestration()));
        }
        if (updateEnvironmentOptions.sessionTimeout() != null) {
            contentJson.addProperty("session_timeout", (Number)updateEnvironmentOptions.sessionTimeout());
        }
        if (updateEnvironmentOptions.skillReferences() != null) {
            contentJson.add("skill_references", GsonSingleton.getGson().toJsonTree(updateEnvironmentOptions.skillReferences()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Environment>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Release> createRelease(CreateReleaseOptions createReleaseOptions) {
        Validator.notNull((Object)((Object)createReleaseOptions), (String)"createReleaseOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("assistant_id", createReleaseOptions.assistantId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants/{assistant_id}/releases", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"createRelease");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        JsonObject contentJson = new JsonObject();
        if (createReleaseOptions.description() != null) {
            contentJson.addProperty("description", createReleaseOptions.description());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Release>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ReleaseCollection> listReleases(ListReleasesOptions listReleasesOptions) {
        Validator.notNull((Object)((Object)listReleasesOptions), (String)"listReleasesOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("assistant_id", listReleasesOptions.assistantId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants/{assistant_id}/releases", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"listReleases");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (listReleasesOptions.pageLimit() != null) {
            builder.query(new Object[]{"page_limit", String.valueOf(listReleasesOptions.pageLimit())});
        }
        if (listReleasesOptions.includeCount() != null) {
            builder.query(new Object[]{"include_count", String.valueOf(listReleasesOptions.includeCount())});
        }
        if (listReleasesOptions.sort() != null) {
            builder.query(new Object[]{"sort", String.valueOf(listReleasesOptions.sort())});
        }
        if (listReleasesOptions.cursor() != null) {
            builder.query(new Object[]{"cursor", String.valueOf(listReleasesOptions.cursor())});
        }
        if (listReleasesOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(listReleasesOptions.includeAudit())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ReleaseCollection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Release> getRelease(GetReleaseOptions getReleaseOptions) {
        Validator.notNull((Object)((Object)getReleaseOptions), (String)"getReleaseOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("assistant_id", getReleaseOptions.assistantId());
        pathParamsMap.put("release", getReleaseOptions.release());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants/{assistant_id}/releases/{release}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"getRelease");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (getReleaseOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(getReleaseOptions.includeAudit())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Release>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteRelease(DeleteReleaseOptions deleteReleaseOptions) {
        Validator.notNull((Object)((Object)deleteReleaseOptions), (String)"deleteReleaseOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("assistant_id", deleteReleaseOptions.assistantId());
        pathParamsMap.put("release", deleteReleaseOptions.release());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants/{assistant_id}/releases/{release}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"deleteRelease");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Environment> deployRelease(DeployReleaseOptions deployReleaseOptions) {
        Validator.notNull((Object)((Object)deployReleaseOptions), (String)"deployReleaseOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("assistant_id", deployReleaseOptions.assistantId());
        pathParamsMap.put("release", deployReleaseOptions.release());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants/{assistant_id}/releases/{release}/deploy", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"deployRelease");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (deployReleaseOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(deployReleaseOptions.includeAudit())});
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("environment_id", deployReleaseOptions.environmentId());
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Environment>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<CreateReleaseExportWithStatusErrors> createReleaseExport(CreateReleaseExportOptions createReleaseExportOptions) {
        Validator.notNull((Object)((Object)createReleaseExportOptions), (String)"createReleaseExportOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("assistant_id", createReleaseExportOptions.assistantId());
        pathParamsMap.put("release", createReleaseExportOptions.release());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants/{assistant_id}/releases/{release}/export", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"createReleaseExport");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (createReleaseExportOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(createReleaseExportOptions.includeAudit())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<CreateReleaseExportWithStatusErrors>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<CreateReleaseExportWithStatusErrors> downloadReleaseExport(DownloadReleaseExportOptions downloadReleaseExportOptions) {
        Validator.notNull((Object)((Object)downloadReleaseExportOptions), (String)"downloadReleaseExportOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("assistant_id", downloadReleaseExportOptions.assistantId());
        pathParamsMap.put("release", downloadReleaseExportOptions.release());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants/{assistant_id}/releases/{release}/export", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"downloadReleaseExport");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (downloadReleaseExportOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(downloadReleaseExportOptions.includeAudit())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<CreateReleaseExportWithStatusErrors>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> downloadReleaseExportAsStream(DownloadReleaseExportOptions downloadReleaseExportOptions) {
        Validator.notNull((Object)((Object)downloadReleaseExportOptions), (String)"downloadReleaseExportOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("assistant_id", downloadReleaseExportOptions.assistantId());
        pathParamsMap.put("release", downloadReleaseExportOptions.release());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants/{assistant_id}/releases/{release}/export", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"downloadReleaseExportAsStream");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/octet-stream"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (downloadReleaseExportOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(downloadReleaseExportOptions.includeAudit())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<CreateAssistantReleaseImportResponse> createReleaseImport(CreateReleaseImportOptions createReleaseImportOptions) {
        Validator.notNull((Object)((Object)createReleaseImportOptions), (String)"createReleaseImportOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("assistant_id", createReleaseImportOptions.assistantId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants/{assistant_id}/import", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"createReleaseImport");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (createReleaseImportOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(createReleaseImportOptions.includeAudit())});
        }
        builder.bodyContent(createReleaseImportOptions.body(), "application/octet-stream");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<CreateAssistantReleaseImportResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<MonitorAssistantReleaseImportArtifactResponse> getReleaseImportStatus(GetReleaseImportStatusOptions getReleaseImportStatusOptions) {
        Validator.notNull((Object)((Object)getReleaseImportStatusOptions), (String)"getReleaseImportStatusOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("assistant_id", getReleaseImportStatusOptions.assistantId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants/{assistant_id}/import", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"getReleaseImportStatus");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (getReleaseImportStatusOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(getReleaseImportStatusOptions.includeAudit())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<MonitorAssistantReleaseImportArtifactResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Skill> getSkill(GetSkillOptions getSkillOptions) {
        Validator.notNull((Object)((Object)getSkillOptions), (String)"getSkillOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("assistant_id", getSkillOptions.assistantId());
        pathParamsMap.put("skill_id", getSkillOptions.skillId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants/{assistant_id}/skills/{skill_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"getSkill");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Skill>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Skill> updateSkill(UpdateSkillOptions updateSkillOptions) {
        Validator.notNull((Object)((Object)updateSkillOptions), (String)"updateSkillOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("assistant_id", updateSkillOptions.assistantId());
        pathParamsMap.put("skill_id", updateSkillOptions.skillId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants/{assistant_id}/skills/{skill_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"updateSkill");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        JsonObject contentJson = new JsonObject();
        if (updateSkillOptions.name() != null) {
            contentJson.addProperty("name", updateSkillOptions.name());
        }
        if (updateSkillOptions.description() != null) {
            contentJson.addProperty("description", updateSkillOptions.description());
        }
        if (updateSkillOptions.workspace() != null) {
            contentJson.add("workspace", GsonSingleton.getGson().toJsonTree(updateSkillOptions.workspace()));
        }
        if (updateSkillOptions.dialogSettings() != null) {
            contentJson.add("dialog_settings", GsonSingleton.getGson().toJsonTree(updateSkillOptions.dialogSettings()));
        }
        if (updateSkillOptions.searchSettings() != null) {
            contentJson.add("search_settings", GsonSingleton.getGson().toJsonTree((Object)updateSkillOptions.searchSettings()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Skill>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SkillsExport> exportSkills(ExportSkillsOptions exportSkillsOptions) {
        Validator.notNull((Object)((Object)exportSkillsOptions), (String)"exportSkillsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("assistant_id", exportSkillsOptions.assistantId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants/{assistant_id}/skills_export", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"exportSkills");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (exportSkillsOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(exportSkillsOptions.includeAudit())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SkillsExport>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SkillsAsyncRequestStatus> importSkills(ImportSkillsOptions importSkillsOptions) {
        Validator.notNull((Object)((Object)importSkillsOptions), (String)"importSkillsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("assistant_id", importSkillsOptions.assistantId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants/{assistant_id}/skills_import", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"importSkills");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (importSkillsOptions.includeAudit() != null) {
            builder.query(new Object[]{"include_audit", String.valueOf(importSkillsOptions.includeAudit())});
        }
        JsonObject contentJson = new JsonObject();
        contentJson.add("assistant_skills", GsonSingleton.getGson().toJsonTree(importSkillsOptions.assistantSkills()));
        contentJson.add("assistant_state", GsonSingleton.getGson().toJsonTree((Object)importSkillsOptions.assistantState()));
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SkillsAsyncRequestStatus>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SkillsAsyncRequestStatus> importSkillsStatus(ImportSkillsStatusOptions importSkillsStatusOptions) {
        Validator.notNull((Object)((Object)importSkillsStatusOptions), (String)"importSkillsStatusOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("assistant_id", importSkillsStatusOptions.assistantId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v2/assistants/{assistant_id}/skills_import/status", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"importSkillsStatus");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SkillsAsyncRequestStatus>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }
}

