/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v2.model.BulkClassifyUtterance;
import java.util.ArrayList;
import java.util.List;

public class BulkClassifyOptions
extends GenericModel {
    protected String skillId;
    protected List<BulkClassifyUtterance> input;

    protected BulkClassifyOptions() {
    }

    protected BulkClassifyOptions(Builder builder) {
        Validator.notEmpty((String)builder.skillId, (String)"skillId cannot be empty");
        Validator.notNull((Object)builder.input, (String)"input cannot be null");
        this.skillId = builder.skillId;
        this.input = builder.input;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String skillId() {
        return this.skillId;
    }

    public List<BulkClassifyUtterance> input() {
        return this.input;
    }

    public static class Builder {
        private String skillId;
        private List<BulkClassifyUtterance> input;

        private Builder(BulkClassifyOptions bulkClassifyOptions) {
            this.skillId = bulkClassifyOptions.skillId;
            this.input = bulkClassifyOptions.input;
        }

        public Builder() {
        }

        public Builder(String skillId, List<BulkClassifyUtterance> input) {
            this.skillId = skillId;
            this.input = input;
        }

        public BulkClassifyOptions build() {
            return new BulkClassifyOptions(this);
        }

        public Builder addInput(BulkClassifyUtterance input) {
            Validator.notNull((Object)((Object)input), (String)"input cannot be null");
            if (this.input == null) {
                this.input = new ArrayList<BulkClassifyUtterance>();
            }
            this.input.add(input);
            return this;
        }

        public Builder skillId(String skillId) {
            this.skillId = skillId;
            return this;
        }

        public Builder input(List<BulkClassifyUtterance> input) {
            this.input = input;
            return this;
        }
    }
}

