/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class CreateReleaseExportOptions
extends GenericModel {
    protected String assistantId;
    protected String release;
    protected Boolean includeAudit;

    protected CreateReleaseExportOptions() {
    }

    protected CreateReleaseExportOptions(Builder builder) {
        Validator.notEmpty((String)builder.assistantId, (String)"assistantId cannot be empty");
        Validator.notEmpty((String)builder.release, (String)"release cannot be empty");
        this.assistantId = builder.assistantId;
        this.release = builder.release;
        this.includeAudit = builder.includeAudit;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String assistantId() {
        return this.assistantId;
    }

    public String release() {
        return this.release;
    }

    public Boolean includeAudit() {
        return this.includeAudit;
    }

    public static class Builder {
        private String assistantId;
        private String release;
        private Boolean includeAudit;

        private Builder(CreateReleaseExportOptions createReleaseExportOptions) {
            this.assistantId = createReleaseExportOptions.assistantId;
            this.release = createReleaseExportOptions.release;
            this.includeAudit = createReleaseExportOptions.includeAudit;
        }

        public Builder() {
        }

        public Builder(String assistantId, String release) {
            this.assistantId = assistantId;
            this.release = release;
        }

        public CreateReleaseExportOptions build() {
            return new CreateReleaseExportOptions(this);
        }

        public Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public Builder release(String release) {
            this.release = release;
            return this;
        }

        public Builder includeAudit(Boolean includeAudit) {
            this.includeAudit = includeAudit;
            return this;
        }
    }
}

