/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class CreateReleaseImportOptions
extends GenericModel {
    protected String assistantId;
    protected InputStream body;
    protected Boolean includeAudit;

    protected CreateReleaseImportOptions() {
    }

    protected CreateReleaseImportOptions(Builder builder) {
        Validator.notEmpty((String)builder.assistantId, (String)"assistantId cannot be empty");
        Validator.notNull((Object)builder.body, (String)"body cannot be null");
        this.assistantId = builder.assistantId;
        this.body = builder.body;
        this.includeAudit = builder.includeAudit;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String assistantId() {
        return this.assistantId;
    }

    public InputStream body() {
        return this.body;
    }

    public Boolean includeAudit() {
        return this.includeAudit;
    }

    public static class Builder {
        private String assistantId;
        private InputStream body;
        private Boolean includeAudit;

        private Builder(CreateReleaseImportOptions createReleaseImportOptions) {
            this.assistantId = createReleaseImportOptions.assistantId;
            this.body = createReleaseImportOptions.body;
            this.includeAudit = createReleaseImportOptions.includeAudit;
        }

        public Builder() {
        }

        public Builder(String assistantId, InputStream body) {
            this.assistantId = assistantId;
            this.body = body;
        }

        public CreateReleaseImportOptions build() {
            return new CreateReleaseImportOptions(this);
        }

        public Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public Builder body(InputStream body) {
            this.body = body;
            return this;
        }

        public Builder includeAudit(Boolean includeAudit) {
            this.includeAudit = includeAudit;
            return this;
        }

        public Builder body(File body) throws FileNotFoundException {
            this.body = new FileInputStream(body);
            return this;
        }
    }
}

