/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2.model;

import com.google.gson.Gson;
import com.ibm.watson.assistant.v2.model.InputStreamConnectStrategy;
import com.ibm.watson.assistant.v2.model.MessageStreamResponse;
import com.ibm.watson.assistant.v2.model.StatelessMessageStreamResponse;
import com.launchdarkly.eventsource.ConnectStrategy;
import com.launchdarkly.eventsource.EventSource;
import com.launchdarkly.eventsource.MessageEvent;
import java.io.InputStream;
import java.util.Iterator;

public class MessageEventDeserializer
extends MessageStreamResponse {
    protected EventSource eventSource;

    protected MessageEventDeserializer() {
    }

    protected MessageEventDeserializer(Builder builder) {
        this.eventSource = builder.eventSource;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public Iterable<MessageStreamResponse> messages() {
        return () -> new IteratorImpl(this.eventSource.messages());
    }

    public Iterable<StatelessMessageStreamResponse> statelessMessages() {
        return () -> new StatelessIteratorImpl(this.eventSource.messages());
    }

    private class StatelessIteratorImpl<T extends StatelessMessageStreamResponse>
    implements Iterator<T> {
        private final Iterable<MessageEvent> messageEvents;

        StatelessIteratorImpl(Iterable<MessageEvent> messageEvents) {
            this.messageEvents = messageEvents;
        }

        @Override
        public boolean hasNext() {
            return this.messageEvents.iterator().hasNext();
        }

        @Override
        public T next() {
            Gson gson = new Gson();
            MessageEvent messageEvent = this.messageEvents.iterator().next();
            StatelessMessageStreamResponse item = (StatelessMessageStreamResponse)((Object)gson.fromJson(messageEvent.getData(), StatelessMessageStreamResponse.class));
            return (T)((Object)item);
        }
    }

    private class IteratorImpl<T extends MessageStreamResponse>
    implements Iterator<T> {
        private final Iterable<MessageEvent> messageEvents;

        IteratorImpl(Iterable<MessageEvent> messageEvents) {
            this.messageEvents = messageEvents;
        }

        @Override
        public boolean hasNext() {
            return this.messageEvents.iterator().hasNext();
        }

        @Override
        public T next() {
            Gson gson = new Gson();
            MessageEvent messageEvent = this.messageEvents.iterator().next();
            MessageStreamResponse item = (MessageStreamResponse)((Object)gson.fromJson(messageEvent.getData(), MessageStreamResponse.class));
            return (T)((Object)item);
        }
    }

    public static class Builder {
        private EventSource eventSource;

        private Builder(MessageEventDeserializer messageEventDeserializer) {
            this.eventSource = messageEventDeserializer.eventSource;
        }

        public Builder() {
        }

        public Builder(InputStream inputStream) {
            InputStreamConnectStrategy inputStreamConnectStrategy = new InputStreamConnectStrategy.Builder().inputStream(inputStream).build();
            this.eventSource = new EventSource.Builder((ConnectStrategy)inputStreamConnectStrategy).build();
        }

        public MessageEventDeserializer build() {
            return new MessageEventDeserializer(this);
        }

        public Builder inputStream(InputStream inputStream) {
            InputStreamConnectStrategy inputStreamConnectStrategy = new InputStreamConnectStrategy.Builder().inputStream(inputStream).build();
            this.eventSource = new EventSource.Builder((ConnectStrategy)inputStreamConnectStrategy).build();
            return this;
        }
    }
}

