/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v2.model.MessageContext;
import com.ibm.watson.assistant.v2.model.MessageInput;

public class MessageOptions
extends GenericModel {
    protected String assistantId;
    protected String environmentId;
    protected String sessionId;
    protected MessageInput input;
    protected MessageContext context;
    protected String userId;

    protected MessageOptions() {
    }

    protected MessageOptions(Builder builder) {
        Validator.notEmpty((String)builder.assistantId, (String)"assistantId cannot be empty");
        Validator.notEmpty((String)builder.environmentId, (String)"environmentId cannot be empty");
        Validator.notEmpty((String)builder.sessionId, (String)"sessionId cannot be empty");
        this.assistantId = builder.assistantId;
        this.environmentId = builder.environmentId;
        this.sessionId = builder.sessionId;
        this.input = builder.input;
        this.context = builder.context;
        this.userId = builder.userId;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String assistantId() {
        return this.assistantId;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String sessionId() {
        return this.sessionId;
    }

    public MessageInput input() {
        return this.input;
    }

    public MessageContext context() {
        return this.context;
    }

    public String userId() {
        return this.userId;
    }

    public static class Builder {
        private String assistantId;
        private String environmentId;
        private String sessionId;
        private MessageInput input;
        private MessageContext context;
        private String userId;

        private Builder(MessageOptions messageOptions) {
            this.assistantId = messageOptions.assistantId;
            this.environmentId = messageOptions.environmentId;
            this.sessionId = messageOptions.sessionId;
            this.input = messageOptions.input;
            this.context = messageOptions.context;
            this.userId = messageOptions.userId;
        }

        public Builder() {
        }

        public Builder(String assistantId, String environmentId, String sessionId) {
            this.assistantId = assistantId;
            this.environmentId = environmentId;
            this.sessionId = sessionId;
        }

        public MessageOptions build() {
            return new MessageOptions(this);
        }

        public Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder input(MessageInput input) {
            this.input = input;
            return this;
        }

        public Builder context(MessageContext context) {
            this.context = context;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }
    }
}

