/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v2.model.StatelessMessageContext;
import com.ibm.watson.assistant.v2.model.StatelessMessageInput;

public class MessageStatelessOptions
extends GenericModel {
    protected String assistantId;
    protected String environmentId;
    protected StatelessMessageInput input;
    protected StatelessMessageContext context;
    protected String userId;

    protected MessageStatelessOptions() {
    }

    protected MessageStatelessOptions(Builder builder) {
        Validator.notEmpty((String)builder.assistantId, (String)"assistantId cannot be empty");
        Validator.notEmpty((String)builder.environmentId, (String)"environmentId cannot be empty");
        this.assistantId = builder.assistantId;
        this.environmentId = builder.environmentId;
        this.input = builder.input;
        this.context = builder.context;
        this.userId = builder.userId;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String assistantId() {
        return this.assistantId;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public StatelessMessageInput input() {
        return this.input;
    }

    public StatelessMessageContext context() {
        return this.context;
    }

    public String userId() {
        return this.userId;
    }

    public static class Builder {
        private String assistantId;
        private String environmentId;
        private StatelessMessageInput input;
        private StatelessMessageContext context;
        private String userId;

        private Builder(MessageStatelessOptions messageStatelessOptions) {
            this.assistantId = messageStatelessOptions.assistantId;
            this.environmentId = messageStatelessOptions.environmentId;
            this.input = messageStatelessOptions.input;
            this.context = messageStatelessOptions.context;
            this.userId = messageStatelessOptions.userId;
        }

        public Builder() {
        }

        public Builder(String assistantId, String environmentId) {
            this.assistantId = assistantId;
            this.environmentId = environmentId;
        }

        public MessageStatelessOptions build() {
            return new MessageStatelessOptions(this);
        }

        public Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder input(StatelessMessageInput input) {
            this.input = input;
            return this;
        }

        public Builder context(StatelessMessageContext context) {
            this.context = context;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }
    }
}

