/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v2.model.ProviderSpecificationComponents;
import com.ibm.watson.assistant.v2.model.ProviderSpecificationServersItem;
import java.util.ArrayList;
import java.util.List;

public class ProviderSpecification
extends GenericModel {
    protected List<ProviderSpecificationServersItem> servers;
    protected ProviderSpecificationComponents components;

    protected ProviderSpecification() {
    }

    protected ProviderSpecification(Builder builder) {
        Validator.notNull((Object)builder.servers, (String)"servers cannot be null");
        this.servers = builder.servers;
        this.components = builder.components;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public List<ProviderSpecificationServersItem> servers() {
        return this.servers;
    }

    public ProviderSpecificationComponents components() {
        return this.components;
    }

    public static class Builder {
        private List<ProviderSpecificationServersItem> servers;
        private ProviderSpecificationComponents components;

        private Builder(ProviderSpecification providerSpecification) {
            this.servers = providerSpecification.servers;
            this.components = providerSpecification.components;
        }

        public Builder() {
        }

        public Builder(List<ProviderSpecificationServersItem> servers) {
            this.servers = servers;
        }

        public ProviderSpecification build() {
            return new ProviderSpecification(this);
        }

        public Builder addServers(ProviderSpecificationServersItem servers) {
            Validator.notNull((Object)((Object)servers), (String)"servers cannot be null");
            if (this.servers == null) {
                this.servers = new ArrayList<ProviderSpecificationServersItem>();
            }
            this.servers.add(servers);
            return this;
        }

        public Builder servers(List<ProviderSpecificationServersItem> servers) {
            this.servers = servers;
            return this;
        }

        public Builder components(ProviderSpecificationComponents components) {
            this.components = components;
            return this;
        }
    }
}

