/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v2.model.SearchSettingsClientSideSearch;
import com.ibm.watson.assistant.v2.model.SearchSettingsConversationalSearch;
import com.ibm.watson.assistant.v2.model.SearchSettingsDiscovery;
import com.ibm.watson.assistant.v2.model.SearchSettingsElasticSearch;
import com.ibm.watson.assistant.v2.model.SearchSettingsMessages;
import com.ibm.watson.assistant.v2.model.SearchSettingsSchemaMapping;
import com.ibm.watson.assistant.v2.model.SearchSettingsServerSideSearch;

public class SearchSettings
extends GenericModel {
    protected SearchSettingsDiscovery discovery;
    protected SearchSettingsMessages messages;
    @SerializedName(value="schema_mapping")
    protected SearchSettingsSchemaMapping schemaMapping;
    @SerializedName(value="elastic_search")
    protected SearchSettingsElasticSearch elasticSearch;
    @SerializedName(value="conversational_search")
    protected SearchSettingsConversationalSearch conversationalSearch;
    @SerializedName(value="server_side_search")
    protected SearchSettingsServerSideSearch serverSideSearch;
    @SerializedName(value="client_side_search")
    protected SearchSettingsClientSideSearch clientSideSearch;

    protected SearchSettings() {
    }

    protected SearchSettings(Builder builder) {
        Validator.notNull((Object)((Object)builder.discovery), (String)"discovery cannot be null");
        Validator.notNull((Object)((Object)builder.messages), (String)"messages cannot be null");
        Validator.notNull((Object)((Object)builder.schemaMapping), (String)"schemaMapping cannot be null");
        this.discovery = builder.discovery;
        this.messages = builder.messages;
        this.schemaMapping = builder.schemaMapping;
        this.elasticSearch = builder.elasticSearch;
        this.conversationalSearch = builder.conversationalSearch;
        this.serverSideSearch = builder.serverSideSearch;
        this.clientSideSearch = builder.clientSideSearch;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public SearchSettingsDiscovery discovery() {
        return this.discovery;
    }

    public SearchSettingsMessages messages() {
        return this.messages;
    }

    public SearchSettingsSchemaMapping schemaMapping() {
        return this.schemaMapping;
    }

    public SearchSettingsElasticSearch elasticSearch() {
        return this.elasticSearch;
    }

    public SearchSettingsConversationalSearch conversationalSearch() {
        return this.conversationalSearch;
    }

    public SearchSettingsServerSideSearch serverSideSearch() {
        return this.serverSideSearch;
    }

    public SearchSettingsClientSideSearch clientSideSearch() {
        return this.clientSideSearch;
    }

    public static class Builder {
        private SearchSettingsDiscovery discovery;
        private SearchSettingsMessages messages;
        private SearchSettingsSchemaMapping schemaMapping;
        private SearchSettingsElasticSearch elasticSearch;
        private SearchSettingsConversationalSearch conversationalSearch;
        private SearchSettingsServerSideSearch serverSideSearch;
        private SearchSettingsClientSideSearch clientSideSearch;

        private Builder(SearchSettings searchSettings) {
            this.discovery = searchSettings.discovery;
            this.messages = searchSettings.messages;
            this.schemaMapping = searchSettings.schemaMapping;
            this.elasticSearch = searchSettings.elasticSearch;
            this.conversationalSearch = searchSettings.conversationalSearch;
            this.serverSideSearch = searchSettings.serverSideSearch;
            this.clientSideSearch = searchSettings.clientSideSearch;
        }

        public Builder() {
        }

        public Builder(SearchSettingsDiscovery discovery, SearchSettingsMessages messages, SearchSettingsSchemaMapping schemaMapping) {
            this.discovery = discovery;
            this.messages = messages;
            this.schemaMapping = schemaMapping;
        }

        public SearchSettings build() {
            return new SearchSettings(this);
        }

        public Builder discovery(SearchSettingsDiscovery discovery) {
            this.discovery = discovery;
            return this;
        }

        public Builder messages(SearchSettingsMessages messages) {
            this.messages = messages;
            return this;
        }

        public Builder schemaMapping(SearchSettingsSchemaMapping schemaMapping) {
            this.schemaMapping = schemaMapping;
            return this;
        }

        public Builder elasticSearch(SearchSettingsElasticSearch elasticSearch) {
            this.elasticSearch = elasticSearch;
            return this;
        }

        public Builder conversationalSearch(SearchSettingsConversationalSearch conversationalSearch) {
            this.conversationalSearch = conversationalSearch;
            return this;
        }

        public Builder serverSideSearch(SearchSettingsServerSideSearch serverSideSearch) {
            this.serverSideSearch = serverSideSearch;
            return this;
        }

        public Builder clientSideSearch(SearchSettingsClientSideSearch clientSideSearch) {
            this.clientSideSearch = clientSideSearch;
            return this;
        }
    }
}

