/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SearchSettingsElasticSearch
extends GenericModel {
    protected String url;
    protected String port;
    protected String username;
    protected String password;
    protected String index;
    protected List<Object> filter;
    @SerializedName(value="query_body")
    protected Map<String, Object> queryBody;
    @SerializedName(value="managed_index")
    protected String managedIndex;
    protected String apikey;

    protected SearchSettingsElasticSearch() {
    }

    protected SearchSettingsElasticSearch(Builder builder) {
        Validator.notNull((Object)builder.url, (String)"url cannot be null");
        Validator.notNull((Object)builder.port, (String)"port cannot be null");
        Validator.notNull((Object)builder.index, (String)"index cannot be null");
        this.url = builder.url;
        this.port = builder.port;
        this.username = builder.username;
        this.password = builder.password;
        this.index = builder.index;
        this.filter = builder.filter;
        this.queryBody = builder.queryBody;
        this.managedIndex = builder.managedIndex;
        this.apikey = builder.apikey;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String url() {
        return this.url;
    }

    public String port() {
        return this.port;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public String index() {
        return this.index;
    }

    public List<Object> filter() {
        return this.filter;
    }

    public Map<String, Object> queryBody() {
        return this.queryBody;
    }

    public String managedIndex() {
        return this.managedIndex;
    }

    public String apikey() {
        return this.apikey;
    }

    public static class Builder {
        private String url;
        private String port;
        private String username;
        private String password;
        private String index;
        private List<Object> filter;
        private Map<String, Object> queryBody;
        private String managedIndex;
        private String apikey;

        private Builder(SearchSettingsElasticSearch searchSettingsElasticSearch) {
            this.url = searchSettingsElasticSearch.url;
            this.port = searchSettingsElasticSearch.port;
            this.username = searchSettingsElasticSearch.username;
            this.password = searchSettingsElasticSearch.password;
            this.index = searchSettingsElasticSearch.index;
            this.filter = searchSettingsElasticSearch.filter;
            this.queryBody = searchSettingsElasticSearch.queryBody;
            this.managedIndex = searchSettingsElasticSearch.managedIndex;
            this.apikey = searchSettingsElasticSearch.apikey;
        }

        public Builder() {
        }

        public Builder(String url, String port, String index) {
            this.url = url;
            this.port = port;
            this.index = index;
        }

        public SearchSettingsElasticSearch build() {
            return new SearchSettingsElasticSearch(this);
        }

        public Builder addFilter(Object filter) {
            Validator.notNull((Object)filter, (String)"filter cannot be null");
            if (this.filter == null) {
                this.filter = new ArrayList<Object>();
            }
            this.filter.add(filter);
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder port(String port) {
            this.port = port;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder index(String index) {
            this.index = index;
            return this;
        }

        public Builder filter(List<Object> filter) {
            this.filter = filter;
            return this;
        }

        public Builder queryBody(Map<String, Object> queryBody) {
            this.queryBody = queryBody;
            return this;
        }

        public Builder managedIndex(String managedIndex) {
            this.managedIndex = managedIndex;
            return this;
        }

        public Builder apikey(String apikey) {
            this.apikey = apikey;
            return this;
        }
    }
}

