/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v1.model.CreateValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CreateEntityOptions
extends GenericModel {
    private String workspaceId;
    private String entity;
    private String description;
    private Map<String, Object> metadata;
    private Boolean fuzzyMatch;
    private List<CreateValue> values;

    private CreateEntityOptions(Builder builder) {
        Validator.notEmpty((String)builder.workspaceId, (String)"workspaceId cannot be empty");
        Validator.notNull((Object)builder.entity, (String)"entity cannot be null");
        this.workspaceId = builder.workspaceId;
        this.entity = builder.entity;
        this.description = builder.description;
        this.metadata = builder.metadata;
        this.fuzzyMatch = builder.fuzzyMatch;
        this.values = builder.values;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String entity() {
        return this.entity;
    }

    public String description() {
        return this.description;
    }

    public Map<String, Object> metadata() {
        return this.metadata;
    }

    public Boolean fuzzyMatch() {
        return this.fuzzyMatch;
    }

    public List<CreateValue> values() {
        return this.values;
    }

    public static class Builder {
        private String workspaceId;
        private String entity;
        private String description;
        private Map<String, Object> metadata;
        private Boolean fuzzyMatch;
        private List<CreateValue> values;

        private Builder(CreateEntityOptions createEntityOptions) {
            this.workspaceId = createEntityOptions.workspaceId;
            this.entity = createEntityOptions.entity;
            this.description = createEntityOptions.description;
            this.metadata = createEntityOptions.metadata;
            this.fuzzyMatch = createEntityOptions.fuzzyMatch;
            this.values = createEntityOptions.values;
        }

        public Builder() {
        }

        public Builder(String workspaceId, String entity) {
            this.workspaceId = workspaceId;
            this.entity = entity;
        }

        public CreateEntityOptions build() {
            return new CreateEntityOptions(this);
        }

        public Builder addValues(CreateValue values) {
            Validator.notNull((Object)((Object)values), (String)"values cannot be null");
            if (this.values == null) {
                this.values = new ArrayList<CreateValue>();
            }
            this.values.add(values);
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder entity(String entity) {
            this.entity = entity;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder fuzzyMatch(Boolean fuzzyMatch) {
            this.fuzzyMatch = fuzzyMatch;
            return this;
        }

        public Builder values(List<CreateValue> values) {
            this.values = values;
            return this;
        }
    }
}

