/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v1.model.CreateValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CreateValueOptions
extends GenericModel {
    private String workspaceId;
    private String entity;
    private String value;
    private Map<String, Object> metadata;
    private String valueType;
    private List<String> synonyms;
    private List<String> patterns;

    private CreateValueOptions(Builder builder) {
        Validator.notEmpty((String)builder.workspaceId, (String)"workspaceId cannot be empty");
        Validator.notEmpty((String)builder.entity, (String)"entity cannot be empty");
        Validator.notNull((Object)builder.value, (String)"value cannot be null");
        this.workspaceId = builder.workspaceId;
        this.entity = builder.entity;
        this.value = builder.value;
        this.metadata = builder.metadata;
        this.valueType = builder.valueType;
        this.synonyms = builder.synonyms;
        this.patterns = builder.patterns;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String entity() {
        return this.entity;
    }

    public String value() {
        return this.value;
    }

    public Map<String, Object> metadata() {
        return this.metadata;
    }

    public String valueType() {
        return this.valueType;
    }

    public List<String> synonyms() {
        return this.synonyms;
    }

    public List<String> patterns() {
        return this.patterns;
    }

    public static class Builder {
        private String workspaceId;
        private String entity;
        private String value;
        private Map<String, Object> metadata;
        private String valueType;
        private List<String> synonyms;
        private List<String> patterns;

        private Builder(CreateValueOptions createValueOptions) {
            this.workspaceId = createValueOptions.workspaceId;
            this.entity = createValueOptions.entity;
            this.value = createValueOptions.value;
            this.metadata = createValueOptions.metadata;
            this.valueType = createValueOptions.valueType;
            this.synonyms = createValueOptions.synonyms;
            this.patterns = createValueOptions.patterns;
        }

        public Builder() {
        }

        public Builder(String workspaceId, String entity, String value) {
            this.workspaceId = workspaceId;
            this.entity = entity;
            this.value = value;
        }

        public CreateValueOptions build() {
            return new CreateValueOptions(this);
        }

        public Builder addSynonym(String synonym) {
            Validator.notNull((Object)synonym, (String)"synonym cannot be null");
            if (this.synonyms == null) {
                this.synonyms = new ArrayList<String>();
            }
            this.synonyms.add(synonym);
            return this;
        }

        public Builder addPattern(String pattern) {
            Validator.notNull((Object)pattern, (String)"pattern cannot be null");
            if (this.patterns == null) {
                this.patterns = new ArrayList<String>();
            }
            this.patterns.add(pattern);
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder entity(String entity) {
            this.entity = entity;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder valueType(String valueType) {
            this.valueType = valueType;
            return this;
        }

        public Builder synonyms(List<String> synonyms) {
            this.synonyms = synonyms;
            return this;
        }

        public Builder patterns(List<String> patterns) {
            this.patterns = patterns;
            return this;
        }

        public Builder createValue(CreateValue createValue) {
            this.value = createValue.value();
            this.metadata = createValue.metadata();
            this.valueType = createValue.valueType();
            this.synonyms = createValue.synonyms();
            this.patterns = createValue.patterns();
            return this;
        }
    }

    public static interface ValueType {
        public static final String SYNONYMS = "synonyms";
        public static final String PATTERNS = "patterns";
    }
}

