/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v1.model.Example;
import com.ibm.watson.assistant.v1.model.Mention;
import java.util.ArrayList;
import java.util.List;

public class CreateExampleOptions
extends GenericModel {
    private String workspaceId;
    private String intent;
    private String text;
    private List<Mention> mentions;

    private CreateExampleOptions(Builder builder) {
        Validator.notEmpty((String)builder.workspaceId, (String)"workspaceId cannot be empty");
        Validator.notEmpty((String)builder.intent, (String)"intent cannot be empty");
        Validator.notNull((Object)builder.text, (String)"text cannot be null");
        this.workspaceId = builder.workspaceId;
        this.intent = builder.intent;
        this.text = builder.text;
        this.mentions = builder.mentions;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String intent() {
        return this.intent;
    }

    public String text() {
        return this.text;
    }

    public List<Mention> mentions() {
        return this.mentions;
    }

    public static class Builder {
        private String workspaceId;
        private String intent;
        private String text;
        private List<Mention> mentions;

        private Builder(CreateExampleOptions createExampleOptions) {
            this.workspaceId = createExampleOptions.workspaceId;
            this.intent = createExampleOptions.intent;
            this.text = createExampleOptions.text;
            this.mentions = createExampleOptions.mentions;
        }

        public Builder() {
        }

        public Builder(String workspaceId, String intent, String text) {
            this.workspaceId = workspaceId;
            this.intent = intent;
            this.text = text;
        }

        public CreateExampleOptions build() {
            return new CreateExampleOptions(this);
        }

        public Builder addMentions(Mention mentions) {
            Validator.notNull((Object)((Object)mentions), (String)"mentions cannot be null");
            if (this.mentions == null) {
                this.mentions = new ArrayList<Mention>();
            }
            this.mentions.add(mentions);
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder intent(String intent) {
            this.intent = intent;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder mentions(List<Mention> mentions) {
            this.mentions = mentions;
            return this;
        }

        public Builder example(Example example) {
            this.text = example.text();
            this.mentions = example.mentions();
            return this;
        }
    }
}

