/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.Map;

public class DialogNodeAction
extends GenericModel {
    private String name;
    private String type;
    private Map<String, Object> parameters;
    @SerializedName(value="result_variable")
    private String resultVariable;
    private String credentials;

    private DialogNodeAction(Builder builder) {
        Validator.notNull((Object)builder.name, (String)"name cannot be null");
        Validator.notNull((Object)builder.resultVariable, (String)"resultVariable cannot be null");
        this.name = builder.name;
        this.type = builder.type;
        this.parameters = builder.parameters;
        this.resultVariable = builder.resultVariable;
        this.credentials = builder.credentials;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public Map<String, Object> parameters() {
        return this.parameters;
    }

    public String resultVariable() {
        return this.resultVariable;
    }

    public String credentials() {
        return this.credentials;
    }

    public static class Builder {
        private String name;
        private String type;
        private Map<String, Object> parameters;
        private String resultVariable;
        private String credentials;

        private Builder(DialogNodeAction dialogNodeAction) {
            this.name = dialogNodeAction.name;
            this.type = dialogNodeAction.type;
            this.parameters = dialogNodeAction.parameters;
            this.resultVariable = dialogNodeAction.resultVariable;
            this.credentials = dialogNodeAction.credentials;
        }

        public Builder() {
        }

        public Builder(String name, String resultVariable) {
            this.name = name;
            this.resultVariable = resultVariable;
        }

        public DialogNodeAction build() {
            return new DialogNodeAction(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder parameters(Map<String, Object> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder resultVariable(String resultVariable) {
            this.resultVariable = resultVariable;
            return this;
        }

        public Builder credentials(String credentials) {
            this.credentials = credentials;
            return this;
        }
    }

    public static interface Type {
        public static final String CLIENT = "client";
        public static final String SERVER = "server";
        public static final String CLOUD_FUNCTION = "cloud_function";
        public static final String WEB_ACTION = "web_action";
    }
}

