/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v1.model.DialogNodeOutputOptionsElement;
import com.ibm.watson.assistant.v1.model.DialogNodeOutputTextValuesElement;
import java.util.ArrayList;
import java.util.List;

public class DialogNodeOutputGeneric
extends GenericModel {
    @SerializedName(value="response_type")
    private String responseType;
    private List<DialogNodeOutputTextValuesElement> values;
    @SerializedName(value="selection_policy")
    private String selectionPolicy;
    private String delimiter;
    private Long time;
    private Boolean typing;
    private String source;
    private String title;
    private String description;
    private String preference;
    private List<DialogNodeOutputOptionsElement> options;
    @SerializedName(value="message_to_human_agent")
    private String messageToHumanAgent;
    private String query;
    @SerializedName(value="query_type")
    private String queryType;
    private String filter;
    @SerializedName(value="discovery_version")
    private String discoveryVersion;

    private DialogNodeOutputGeneric(Builder builder) {
        Validator.notNull((Object)builder.responseType, (String)"responseType cannot be null");
        this.responseType = builder.responseType;
        this.values = builder.values;
        this.selectionPolicy = builder.selectionPolicy;
        this.delimiter = builder.delimiter;
        this.time = builder.time;
        this.typing = builder.typing;
        this.source = builder.source;
        this.title = builder.title;
        this.description = builder.description;
        this.preference = builder.preference;
        this.options = builder.options;
        this.messageToHumanAgent = builder.messageToHumanAgent;
        this.query = builder.query;
        this.queryType = builder.queryType;
        this.filter = builder.filter;
        this.discoveryVersion = builder.discoveryVersion;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String responseType() {
        return this.responseType;
    }

    public List<DialogNodeOutputTextValuesElement> values() {
        return this.values;
    }

    public String selectionPolicy() {
        return this.selectionPolicy;
    }

    public String delimiter() {
        return this.delimiter;
    }

    public Long time() {
        return this.time;
    }

    public Boolean typing() {
        return this.typing;
    }

    public String source() {
        return this.source;
    }

    public String title() {
        return this.title;
    }

    public String description() {
        return this.description;
    }

    public String preference() {
        return this.preference;
    }

    public List<DialogNodeOutputOptionsElement> options() {
        return this.options;
    }

    public String messageToHumanAgent() {
        return this.messageToHumanAgent;
    }

    public String query() {
        return this.query;
    }

    public String queryType() {
        return this.queryType;
    }

    public String filter() {
        return this.filter;
    }

    public String discoveryVersion() {
        return this.discoveryVersion;
    }

    public static class Builder {
        private String responseType;
        private List<DialogNodeOutputTextValuesElement> values;
        private String selectionPolicy;
        private String delimiter;
        private Long time;
        private Boolean typing;
        private String source;
        private String title;
        private String description;
        private String preference;
        private List<DialogNodeOutputOptionsElement> options;
        private String messageToHumanAgent;
        private String query;
        private String queryType;
        private String filter;
        private String discoveryVersion;

        private Builder(DialogNodeOutputGeneric dialogNodeOutputGeneric) {
            this.responseType = dialogNodeOutputGeneric.responseType;
            this.values = dialogNodeOutputGeneric.values;
            this.selectionPolicy = dialogNodeOutputGeneric.selectionPolicy;
            this.delimiter = dialogNodeOutputGeneric.delimiter;
            this.time = dialogNodeOutputGeneric.time;
            this.typing = dialogNodeOutputGeneric.typing;
            this.source = dialogNodeOutputGeneric.source;
            this.title = dialogNodeOutputGeneric.title;
            this.description = dialogNodeOutputGeneric.description;
            this.preference = dialogNodeOutputGeneric.preference;
            this.options = dialogNodeOutputGeneric.options;
            this.messageToHumanAgent = dialogNodeOutputGeneric.messageToHumanAgent;
            this.query = dialogNodeOutputGeneric.query;
            this.queryType = dialogNodeOutputGeneric.queryType;
            this.filter = dialogNodeOutputGeneric.filter;
            this.discoveryVersion = dialogNodeOutputGeneric.discoveryVersion;
        }

        public Builder() {
        }

        public Builder(String responseType) {
            this.responseType = responseType;
        }

        public DialogNodeOutputGeneric build() {
            return new DialogNodeOutputGeneric(this);
        }

        public Builder addValues(DialogNodeOutputTextValuesElement values) {
            Validator.notNull((Object)((Object)values), (String)"values cannot be null");
            if (this.values == null) {
                this.values = new ArrayList<DialogNodeOutputTextValuesElement>();
            }
            this.values.add(values);
            return this;
        }

        public Builder addOptions(DialogNodeOutputOptionsElement options) {
            Validator.notNull((Object)((Object)options), (String)"options cannot be null");
            if (this.options == null) {
                this.options = new ArrayList<DialogNodeOutputOptionsElement>();
            }
            this.options.add(options);
            return this;
        }

        public Builder responseType(String responseType) {
            this.responseType = responseType;
            return this;
        }

        public Builder values(List<DialogNodeOutputTextValuesElement> values) {
            this.values = values;
            return this;
        }

        public Builder selectionPolicy(String selectionPolicy) {
            this.selectionPolicy = selectionPolicy;
            return this;
        }

        public Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public Builder time(long time) {
            this.time = time;
            return this;
        }

        public Builder typing(Boolean typing) {
            this.typing = typing;
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder preference(String preference) {
            this.preference = preference;
            return this;
        }

        public Builder options(List<DialogNodeOutputOptionsElement> options) {
            this.options = options;
            return this;
        }

        public Builder messageToHumanAgent(String messageToHumanAgent) {
            this.messageToHumanAgent = messageToHumanAgent;
            return this;
        }

        public Builder query(String query) {
            this.query = query;
            return this;
        }

        public Builder queryType(String queryType) {
            this.queryType = queryType;
            return this;
        }

        public Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder discoveryVersion(String discoveryVersion) {
            this.discoveryVersion = discoveryVersion;
            return this;
        }
    }

    public static interface QueryType {
        public static final String NATURAL_LANGUAGE = "natural_language";
        public static final String DISCOVERY_QUERY_LANGUAGE = "discovery_query_language";
    }

    public static interface Preference {
        public static final String DROPDOWN = "dropdown";
        public static final String BUTTON = "button";
    }

    public static interface SelectionPolicy {
        public static final String SEQUENTIAL = "sequential";
        public static final String RANDOM = "random";
        public static final String MULTILINE = "multiline";
    }

    public static interface ResponseType {
        public static final String TEXT = "text";
        public static final String PAUSE = "pause";
        public static final String IMAGE = "image";
        public static final String OPTION = "option";
        public static final String CONNECT_TO_AGENT = "connect_to_agent";
        public static final String SEARCH_SKILL = "search_skill";
    }
}

