/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v1.model.Mention;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Example
extends GenericModel {
    private String text;
    private List<Mention> mentions;
    private Date created;
    private Date updated;

    private Example(Builder builder) {
        Validator.notNull((Object)builder.text, (String)"text cannot be null");
        this.text = builder.text;
        this.mentions = builder.mentions;
        this.created = builder.created;
        this.updated = builder.updated;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String text() {
        return this.text;
    }

    public List<Mention> mentions() {
        return this.mentions;
    }

    public Date created() {
        return this.created;
    }

    public Date updated() {
        return this.updated;
    }

    public static class Builder {
        private String text;
        private List<Mention> mentions;
        private Date created;
        private Date updated;

        private Builder(Example example) {
            this.text = example.text;
            this.mentions = example.mentions;
            this.created = example.created;
            this.updated = example.updated;
        }

        public Builder() {
        }

        public Builder(String text) {
            this.text = text;
        }

        public Example build() {
            return new Example(this);
        }

        public Builder addMentions(Mention mentions) {
            Validator.notNull((Object)((Object)mentions), (String)"mentions cannot be null");
            if (this.mentions == null) {
                this.mentions = new ArrayList<Mention>();
            }
            this.mentions.add(mentions);
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder mentions(List<Mention> mentions) {
            this.mentions = mentions;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder updated(Date updated) {
            this.updated = updated;
            return this;
        }
    }
}

