/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class ListSynonymsOptions
extends GenericModel {
    private String workspaceId;
    private String entity;
    private String value;
    private Long pageLimit;
    private String sort;
    private String cursor;
    private Boolean includeAudit;

    private ListSynonymsOptions(Builder builder) {
        Validator.notEmpty((String)builder.workspaceId, (String)"workspaceId cannot be empty");
        Validator.notEmpty((String)builder.entity, (String)"entity cannot be empty");
        Validator.notEmpty((String)builder.value, (String)"value cannot be empty");
        this.workspaceId = builder.workspaceId;
        this.entity = builder.entity;
        this.value = builder.value;
        this.pageLimit = builder.pageLimit;
        this.sort = builder.sort;
        this.cursor = builder.cursor;
        this.includeAudit = builder.includeAudit;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String entity() {
        return this.entity;
    }

    public String value() {
        return this.value;
    }

    public Long pageLimit() {
        return this.pageLimit;
    }

    public String sort() {
        return this.sort;
    }

    public String cursor() {
        return this.cursor;
    }

    public Boolean includeAudit() {
        return this.includeAudit;
    }

    public static class Builder {
        private String workspaceId;
        private String entity;
        private String value;
        private Long pageLimit;
        private String sort;
        private String cursor;
        private Boolean includeAudit;

        private Builder(ListSynonymsOptions listSynonymsOptions) {
            this.workspaceId = listSynonymsOptions.workspaceId;
            this.entity = listSynonymsOptions.entity;
            this.value = listSynonymsOptions.value;
            this.pageLimit = listSynonymsOptions.pageLimit;
            this.sort = listSynonymsOptions.sort;
            this.cursor = listSynonymsOptions.cursor;
            this.includeAudit = listSynonymsOptions.includeAudit;
        }

        public Builder() {
        }

        public Builder(String workspaceId, String entity, String value) {
            this.workspaceId = workspaceId;
            this.entity = entity;
            this.value = value;
        }

        public ListSynonymsOptions build() {
            return new ListSynonymsOptions(this);
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder entity(String entity) {
            this.entity = entity;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder pageLimit(long pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }

        public Builder sort(String sort) {
            this.sort = sort;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder includeAudit(Boolean includeAudit) {
            this.includeAudit = includeAudit;
            return this;
        }
    }

    public static interface Sort {
        public static final String SYNONYM = "synonym";
        public static final String UPDATED = "updated";
    }
}

