/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class Mention
extends GenericModel {
    private String entity;
    private List<Long> location;

    private Mention(Builder builder) {
        Validator.notNull((Object)builder.entity, (String)"entity cannot be null");
        Validator.notNull((Object)builder.location, (String)"location cannot be null");
        this.entity = builder.entity;
        this.location = builder.location;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String entity() {
        return this.entity;
    }

    public List<Long> location() {
        return this.location;
    }

    public static class Builder {
        private String entity;
        private List<Long> location;

        private Builder(Mention mention) {
            this.entity = mention.entity;
            this.location = mention.location;
        }

        public Builder() {
        }

        public Builder(String entity, List<Long> location) {
            this.entity = entity;
            this.location = location;
        }

        public Mention build() {
            return new Mention(this);
        }

        public Builder addLocation(Long location) {
            Validator.notNull((Object)location, (String)"location cannot be null");
            if (this.location == null) {
                this.location = new ArrayList<Long>();
            }
            this.location.add(location);
            return this;
        }

        public Builder entity(String entity) {
            this.entity = entity;
            return this;
        }

        public Builder location(List<Long> location) {
            this.location = location;
            return this;
        }
    }
}

