/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v1.model.DialogNodeAction;
import com.ibm.watson.assistant.v1.model.DialogNodeNextStep;
import com.ibm.watson.assistant.v1.model.DialogNodeOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UpdateDialogNodeOptions
extends GenericModel {
    private String workspaceId;
    private String dialogNode;
    private String newDialogNode;
    private String newDescription;
    private String newConditions;
    private String newParent;
    private String newPreviousSibling;
    private DialogNodeOutput newOutput;
    private Map<String, Object> newContext;
    private Map<String, Object> newMetadata;
    private DialogNodeNextStep newNextStep;
    private String newTitle;
    private String newType;
    private String newEventName;
    private String newVariable;
    private List<DialogNodeAction> newActions;
    private String newDigressIn;
    private String newDigressOut;
    private String newDigressOutSlots;
    private String newUserLabel;

    private UpdateDialogNodeOptions(Builder builder) {
        Validator.notEmpty((String)builder.workspaceId, (String)"workspaceId cannot be empty");
        Validator.notEmpty((String)builder.dialogNode, (String)"dialogNode cannot be empty");
        this.workspaceId = builder.workspaceId;
        this.dialogNode = builder.dialogNode;
        this.newDialogNode = builder.newDialogNode;
        this.newDescription = builder.newDescription;
        this.newConditions = builder.newConditions;
        this.newParent = builder.newParent;
        this.newPreviousSibling = builder.newPreviousSibling;
        this.newOutput = builder.newOutput;
        this.newContext = builder.newContext;
        this.newMetadata = builder.newMetadata;
        this.newNextStep = builder.newNextStep;
        this.newTitle = builder.newTitle;
        this.newType = builder.newType;
        this.newEventName = builder.newEventName;
        this.newVariable = builder.newVariable;
        this.newActions = builder.newActions;
        this.newDigressIn = builder.newDigressIn;
        this.newDigressOut = builder.newDigressOut;
        this.newDigressOutSlots = builder.newDigressOutSlots;
        this.newUserLabel = builder.newUserLabel;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String dialogNode() {
        return this.dialogNode;
    }

    public String newDialogNode() {
        return this.newDialogNode;
    }

    public String newDescription() {
        return this.newDescription;
    }

    public String newConditions() {
        return this.newConditions;
    }

    public String newParent() {
        return this.newParent;
    }

    public String newPreviousSibling() {
        return this.newPreviousSibling;
    }

    public DialogNodeOutput newOutput() {
        return this.newOutput;
    }

    public Map<String, Object> newContext() {
        return this.newContext;
    }

    public Map<String, Object> newMetadata() {
        return this.newMetadata;
    }

    public DialogNodeNextStep newNextStep() {
        return this.newNextStep;
    }

    public String newTitle() {
        return this.newTitle;
    }

    public String newType() {
        return this.newType;
    }

    public String newEventName() {
        return this.newEventName;
    }

    public String newVariable() {
        return this.newVariable;
    }

    public List<DialogNodeAction> newActions() {
        return this.newActions;
    }

    public String newDigressIn() {
        return this.newDigressIn;
    }

    public String newDigressOut() {
        return this.newDigressOut;
    }

    public String newDigressOutSlots() {
        return this.newDigressOutSlots;
    }

    public String newUserLabel() {
        return this.newUserLabel;
    }

    public static class Builder {
        private String workspaceId;
        private String dialogNode;
        private String newDialogNode;
        private String newDescription;
        private String newConditions;
        private String newParent;
        private String newPreviousSibling;
        private DialogNodeOutput newOutput;
        private Map<String, Object> newContext;
        private Map<String, Object> newMetadata;
        private DialogNodeNextStep newNextStep;
        private String newTitle;
        private String newType;
        private String newEventName;
        private String newVariable;
        private List<DialogNodeAction> newActions;
        private String newDigressIn;
        private String newDigressOut;
        private String newDigressOutSlots;
        private String newUserLabel;

        private Builder(UpdateDialogNodeOptions updateDialogNodeOptions) {
            this.workspaceId = updateDialogNodeOptions.workspaceId;
            this.dialogNode = updateDialogNodeOptions.dialogNode;
            this.newDialogNode = updateDialogNodeOptions.newDialogNode;
            this.newDescription = updateDialogNodeOptions.newDescription;
            this.newConditions = updateDialogNodeOptions.newConditions;
            this.newParent = updateDialogNodeOptions.newParent;
            this.newPreviousSibling = updateDialogNodeOptions.newPreviousSibling;
            this.newOutput = updateDialogNodeOptions.newOutput;
            this.newContext = updateDialogNodeOptions.newContext;
            this.newMetadata = updateDialogNodeOptions.newMetadata;
            this.newNextStep = updateDialogNodeOptions.newNextStep;
            this.newTitle = updateDialogNodeOptions.newTitle;
            this.newType = updateDialogNodeOptions.newType;
            this.newEventName = updateDialogNodeOptions.newEventName;
            this.newVariable = updateDialogNodeOptions.newVariable;
            this.newActions = updateDialogNodeOptions.newActions;
            this.newDigressIn = updateDialogNodeOptions.newDigressIn;
            this.newDigressOut = updateDialogNodeOptions.newDigressOut;
            this.newDigressOutSlots = updateDialogNodeOptions.newDigressOutSlots;
            this.newUserLabel = updateDialogNodeOptions.newUserLabel;
        }

        public Builder() {
        }

        public Builder(String workspaceId, String dialogNode) {
            this.workspaceId = workspaceId;
            this.dialogNode = dialogNode;
        }

        public UpdateDialogNodeOptions build() {
            return new UpdateDialogNodeOptions(this);
        }

        public Builder addNewActions(DialogNodeAction newActions) {
            Validator.notNull((Object)((Object)newActions), (String)"newActions cannot be null");
            if (this.newActions == null) {
                this.newActions = new ArrayList<DialogNodeAction>();
            }
            this.newActions.add(newActions);
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder dialogNode(String dialogNode) {
            this.dialogNode = dialogNode;
            return this;
        }

        public Builder newDialogNode(String newDialogNode) {
            this.newDialogNode = newDialogNode;
            return this;
        }

        public Builder newDescription(String newDescription) {
            this.newDescription = newDescription;
            return this;
        }

        public Builder newConditions(String newConditions) {
            this.newConditions = newConditions;
            return this;
        }

        public Builder newParent(String newParent) {
            this.newParent = newParent;
            return this;
        }

        public Builder newPreviousSibling(String newPreviousSibling) {
            this.newPreviousSibling = newPreviousSibling;
            return this;
        }

        public Builder newOutput(DialogNodeOutput newOutput) {
            this.newOutput = newOutput;
            return this;
        }

        public Builder newContext(Map<String, Object> newContext) {
            this.newContext = newContext;
            return this;
        }

        public Builder newMetadata(Map<String, Object> newMetadata) {
            this.newMetadata = newMetadata;
            return this;
        }

        public Builder newNextStep(DialogNodeNextStep newNextStep) {
            this.newNextStep = newNextStep;
            return this;
        }

        public Builder newTitle(String newTitle) {
            this.newTitle = newTitle;
            return this;
        }

        public Builder newType(String newType) {
            this.newType = newType;
            return this;
        }

        public Builder newEventName(String newEventName) {
            this.newEventName = newEventName;
            return this;
        }

        public Builder newVariable(String newVariable) {
            this.newVariable = newVariable;
            return this;
        }

        public Builder newActions(List<DialogNodeAction> newActions) {
            this.newActions = newActions;
            return this;
        }

        public Builder newDigressIn(String newDigressIn) {
            this.newDigressIn = newDigressIn;
            return this;
        }

        public Builder newDigressOut(String newDigressOut) {
            this.newDigressOut = newDigressOut;
            return this;
        }

        public Builder newDigressOutSlots(String newDigressOutSlots) {
            this.newDigressOutSlots = newDigressOutSlots;
            return this;
        }

        public Builder newUserLabel(String newUserLabel) {
            this.newUserLabel = newUserLabel;
            return this;
        }
    }

    public static interface NewDigressOutSlots {
        public static final String NOT_ALLOWED = "not_allowed";
        public static final String ALLOW_RETURNING = "allow_returning";
        public static final String ALLOW_ALL = "allow_all";
    }

    public static interface NewDigressOut {
        public static final String ALLOW_RETURNING = "allow_returning";
        public static final String ALLOW_ALL = "allow_all";
        public static final String ALLOW_ALL_NEVER_RETURN = "allow_all_never_return";
    }

    public static interface NewDigressIn {
        public static final String NOT_AVAILABLE = "not_available";
        public static final String RETURNS = "returns";
        public static final String DOES_NOT_RETURN = "does_not_return";
    }

    public static interface NewEventName {
        public static final String FOCUS = "focus";
        public static final String INPUT = "input";
        public static final String FILLED = "filled";
        public static final String VALIDATE = "validate";
        public static final String FILLED_MULTIPLE = "filled_multiple";
        public static final String GENERIC = "generic";
        public static final String NOMATCH = "nomatch";
        public static final String NOMATCH_RESPONSES_DEPLETED = "nomatch_responses_depleted";
        public static final String DIGRESSION_RETURN_PROMPT = "digression_return_prompt";
    }

    public static interface NewType {
        public static final String STANDARD = "standard";
        public static final String EVENT_HANDLER = "event_handler";
        public static final String FRAME = "frame";
        public static final String SLOT = "slot";
        public static final String RESPONSE_CONDITION = "response_condition";
        public static final String FOLDER = "folder";
    }
}

