/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v1.model.Mention;
import java.util.ArrayList;
import java.util.List;

public class UpdateExampleOptions
extends GenericModel {
    private String workspaceId;
    private String intent;
    private String text;
    private String newText;
    private List<Mention> newMentions;

    private UpdateExampleOptions(Builder builder) {
        Validator.notEmpty((String)builder.workspaceId, (String)"workspaceId cannot be empty");
        Validator.notEmpty((String)builder.intent, (String)"intent cannot be empty");
        Validator.notEmpty((String)builder.text, (String)"text cannot be empty");
        this.workspaceId = builder.workspaceId;
        this.intent = builder.intent;
        this.text = builder.text;
        this.newText = builder.newText;
        this.newMentions = builder.newMentions;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String intent() {
        return this.intent;
    }

    public String text() {
        return this.text;
    }

    public String newText() {
        return this.newText;
    }

    public List<Mention> newMentions() {
        return this.newMentions;
    }

    public static class Builder {
        private String workspaceId;
        private String intent;
        private String text;
        private String newText;
        private List<Mention> newMentions;

        private Builder(UpdateExampleOptions updateExampleOptions) {
            this.workspaceId = updateExampleOptions.workspaceId;
            this.intent = updateExampleOptions.intent;
            this.text = updateExampleOptions.text;
            this.newText = updateExampleOptions.newText;
            this.newMentions = updateExampleOptions.newMentions;
        }

        public Builder() {
        }

        public Builder(String workspaceId, String intent, String text) {
            this.workspaceId = workspaceId;
            this.intent = intent;
            this.text = text;
        }

        public UpdateExampleOptions build() {
            return new UpdateExampleOptions(this);
        }

        public Builder addNewMentions(Mention newMentions) {
            Validator.notNull((Object)((Object)newMentions), (String)"newMentions cannot be null");
            if (this.newMentions == null) {
                this.newMentions = new ArrayList<Mention>();
            }
            this.newMentions.add(newMentions);
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder intent(String intent) {
            this.intent = intent;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder newText(String newText) {
            this.newText = newText;
            return this;
        }

        public Builder newMentions(List<Mention> newMentions) {
            this.newMentions = newMentions;
            return this;
        }
    }
}

