/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v2.model.MessageContext;
import com.ibm.watson.assistant.v2.model.MessageInput;

public class MessageOptions
extends GenericModel {
    private String assistantId;
    private String sessionId;
    private MessageInput input;
    private MessageContext context;

    private MessageOptions(Builder builder) {
        Validator.notEmpty((String)builder.assistantId, (String)"assistantId cannot be empty");
        Validator.notEmpty((String)builder.sessionId, (String)"sessionId cannot be empty");
        this.assistantId = builder.assistantId;
        this.sessionId = builder.sessionId;
        this.input = builder.input;
        this.context = builder.context;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String assistantId() {
        return this.assistantId;
    }

    public String sessionId() {
        return this.sessionId;
    }

    public MessageInput input() {
        return this.input;
    }

    public MessageContext context() {
        return this.context;
    }

    public static class Builder {
        private String assistantId;
        private String sessionId;
        private MessageInput input;
        private MessageContext context;

        private Builder(MessageOptions messageOptions) {
            this.assistantId = messageOptions.assistantId;
            this.sessionId = messageOptions.sessionId;
            this.input = messageOptions.input;
            this.context = messageOptions.context;
        }

        public Builder() {
        }

        public Builder(String assistantId, String sessionId) {
            this.assistantId = assistantId;
            this.sessionId = sessionId;
        }

        public MessageOptions build() {
            return new MessageOptions(this);
        }

        public Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder input(MessageInput input) {
            this.input = input;
            return this;
        }

        public Builder context(MessageContext context) {
            this.context = context;
            return this;
        }
    }
}

