/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v2.model.CaptureGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RuntimeEntity
extends GenericModel {
    private String entity;
    private List<Long> location;
    private String value;
    private Double confidence;
    private Map<String, Object> metadata;
    private List<CaptureGroup> groups;

    private RuntimeEntity(Builder builder) {
        Validator.notNull((Object)builder.entity, (String)"entity cannot be null");
        Validator.notNull((Object)builder.location, (String)"location cannot be null");
        Validator.notNull((Object)builder.value, (String)"value cannot be null");
        this.entity = builder.entity;
        this.location = builder.location;
        this.value = builder.value;
        this.confidence = builder.confidence;
        this.metadata = builder.metadata;
        this.groups = builder.groups;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String entity() {
        return this.entity;
    }

    public List<Long> location() {
        return this.location;
    }

    public String value() {
        return this.value;
    }

    public Double confidence() {
        return this.confidence;
    }

    public Map<String, Object> metadata() {
        return this.metadata;
    }

    public List<CaptureGroup> groups() {
        return this.groups;
    }

    public static class Builder {
        private String entity;
        private List<Long> location;
        private String value;
        private Double confidence;
        private Map<String, Object> metadata;
        private List<CaptureGroup> groups;

        private Builder(RuntimeEntity runtimeEntity) {
            this.entity = runtimeEntity.entity;
            this.location = runtimeEntity.location;
            this.value = runtimeEntity.value;
            this.confidence = runtimeEntity.confidence;
            this.metadata = runtimeEntity.metadata;
            this.groups = runtimeEntity.groups;
        }

        public Builder() {
        }

        public Builder(String entity, List<Long> location, String value) {
            this.entity = entity;
            this.location = location;
            this.value = value;
        }

        public RuntimeEntity build() {
            return new RuntimeEntity(this);
        }

        public Builder addLocation(Long location) {
            Validator.notNull((Object)location, (String)"location cannot be null");
            if (this.location == null) {
                this.location = new ArrayList<Long>();
            }
            this.location.add(location);
            return this;
        }

        public Builder addGroups(CaptureGroup groups) {
            Validator.notNull((Object)((Object)groups), (String)"groups cannot be null");
            if (this.groups == null) {
                this.groups = new ArrayList<CaptureGroup>();
            }
            this.groups.add(groups);
            return this;
        }

        public Builder entity(String entity) {
            this.entity = entity;
            return this;
        }

        public Builder location(List<Long> location) {
            this.location = location;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder confidence(Double confidence) {
            this.confidence = confidence;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder groups(List<CaptureGroup> groups) {
            this.groups = groups;
            return this;
        }
    }
}

