/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v1.model.Example;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CreateIntent
extends GenericModel {
    protected String intent;
    protected String description;
    protected Date created;
    protected Date updated;
    protected List<Example> examples;

    protected CreateIntent(Builder builder) {
        Validator.notNull((Object)builder.intent, (String)"intent cannot be null");
        this.intent = builder.intent;
        this.description = builder.description;
        this.created = builder.created;
        this.updated = builder.updated;
        this.examples = builder.examples;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String intent() {
        return this.intent;
    }

    public String description() {
        return this.description;
    }

    public Date created() {
        return this.created;
    }

    public Date updated() {
        return this.updated;
    }

    public List<Example> examples() {
        return this.examples;
    }

    public static class Builder {
        private String intent;
        private String description;
        private Date created;
        private Date updated;
        private List<Example> examples;

        private Builder(CreateIntent createIntent) {
            this.intent = createIntent.intent;
            this.description = createIntent.description;
            this.created = createIntent.created;
            this.updated = createIntent.updated;
            this.examples = createIntent.examples;
        }

        public Builder() {
        }

        public Builder(String intent) {
            this.intent = intent;
        }

        public CreateIntent build() {
            return new CreateIntent(this);
        }

        public Builder addExample(Example example) {
            Validator.notNull((Object)((Object)example), (String)"example cannot be null");
            if (this.examples == null) {
                this.examples = new ArrayList<Example>();
            }
            this.examples.add(example);
            return this;
        }

        public Builder intent(String intent) {
            this.intent = intent;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder updated(Date updated) {
            this.updated = updated;
            return this;
        }

        public Builder examples(List<Example> examples) {
            this.examples = examples;
            return this;
        }
    }
}

