/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v1.model.CreateValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UpdateEntityOptions
extends GenericModel {
    protected String workspaceId;
    protected String entity;
    protected String newEntity;
    protected String newDescription;
    protected Map<String, Object> newMetadata;
    protected Boolean newFuzzyMatch;
    protected List<CreateValue> newValues;
    protected Boolean append;
    protected Boolean includeAudit;

    protected UpdateEntityOptions(Builder builder) {
        Validator.notEmpty((String)builder.workspaceId, (String)"workspaceId cannot be empty");
        Validator.notEmpty((String)builder.entity, (String)"entity cannot be empty");
        this.workspaceId = builder.workspaceId;
        this.entity = builder.entity;
        this.newEntity = builder.newEntity;
        this.newDescription = builder.newDescription;
        this.newMetadata = builder.newMetadata;
        this.newFuzzyMatch = builder.newFuzzyMatch;
        this.newValues = builder.newValues;
        this.append = builder.append;
        this.includeAudit = builder.includeAudit;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String entity() {
        return this.entity;
    }

    public String newEntity() {
        return this.newEntity;
    }

    public String newDescription() {
        return this.newDescription;
    }

    public Map<String, Object> newMetadata() {
        return this.newMetadata;
    }

    public Boolean newFuzzyMatch() {
        return this.newFuzzyMatch;
    }

    public List<CreateValue> newValues() {
        return this.newValues;
    }

    public Boolean append() {
        return this.append;
    }

    public Boolean includeAudit() {
        return this.includeAudit;
    }

    public static class Builder {
        private String workspaceId;
        private String entity;
        private String newEntity;
        private String newDescription;
        private Map<String, Object> newMetadata;
        private Boolean newFuzzyMatch;
        private List<CreateValue> newValues;
        private Boolean append;
        private Boolean includeAudit;

        private Builder(UpdateEntityOptions updateEntityOptions) {
            this.workspaceId = updateEntityOptions.workspaceId;
            this.entity = updateEntityOptions.entity;
            this.newEntity = updateEntityOptions.newEntity;
            this.newDescription = updateEntityOptions.newDescription;
            this.newMetadata = updateEntityOptions.newMetadata;
            this.newFuzzyMatch = updateEntityOptions.newFuzzyMatch;
            this.newValues = updateEntityOptions.newValues;
            this.append = updateEntityOptions.append;
            this.includeAudit = updateEntityOptions.includeAudit;
        }

        public Builder() {
        }

        public Builder(String workspaceId, String entity) {
            this.workspaceId = workspaceId;
            this.entity = entity;
        }

        public UpdateEntityOptions build() {
            return new UpdateEntityOptions(this);
        }

        public Builder addValue(CreateValue value) {
            Validator.notNull((Object)((Object)value), (String)"value cannot be null");
            if (this.newValues == null) {
                this.newValues = new ArrayList<CreateValue>();
            }
            this.newValues.add(value);
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder entity(String entity) {
            this.entity = entity;
            return this;
        }

        public Builder newEntity(String newEntity) {
            this.newEntity = newEntity;
            return this;
        }

        public Builder newDescription(String newDescription) {
            this.newDescription = newDescription;
            return this;
        }

        public Builder newMetadata(Map<String, Object> newMetadata) {
            this.newMetadata = newMetadata;
            return this;
        }

        public Builder newFuzzyMatch(Boolean newFuzzyMatch) {
            this.newFuzzyMatch = newFuzzyMatch;
            return this;
        }

        public Builder newValues(List<CreateValue> newValues) {
            this.newValues = newValues;
            return this;
        }

        public Builder append(Boolean append) {
            this.append = append;
            return this;
        }

        public Builder includeAudit(Boolean includeAudit) {
            this.includeAudit = includeAudit;
            return this;
        }
    }
}

