/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class CaptureGroup
extends GenericModel {
    protected String group;
    protected List<Long> location;

    protected CaptureGroup(Builder builder) {
        Validator.notNull((Object)builder.group, (String)"group cannot be null");
        this.group = builder.group;
        this.location = builder.location;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String group() {
        return this.group;
    }

    public List<Long> location() {
        return this.location;
    }

    public static class Builder {
        private String group;
        private List<Long> location;

        private Builder(CaptureGroup captureGroup) {
            this.group = captureGroup.group;
            this.location = captureGroup.location;
        }

        public Builder() {
        }

        public Builder(String group) {
            this.group = group;
        }

        public CaptureGroup build() {
            return new CaptureGroup(this);
        }

        public Builder addLocation(Long location) {
            Validator.notNull((Object)location, (String)"location cannot be null");
            if (this.location == null) {
                this.location = new ArrayList<Long>();
            }
            this.location.add(location);
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder location(List<Long> location) {
            this.location = location;
            return this;
        }
    }
}

