/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CreateValueOptions
extends GenericModel {
    protected String workspaceId;
    protected String entity;
    protected String value;
    protected Map<String, Object> metadata;
    protected String type;
    protected List<String> synonyms;
    protected List<String> patterns;
    protected Boolean includeAudit;

    protected CreateValueOptions(Builder builder) {
        Validator.notEmpty((String)builder.workspaceId, (String)"workspaceId cannot be empty");
        Validator.notEmpty((String)builder.entity, (String)"entity cannot be empty");
        Validator.notNull((Object)builder.value, (String)"value cannot be null");
        this.workspaceId = builder.workspaceId;
        this.entity = builder.entity;
        this.value = builder.value;
        this.metadata = builder.metadata;
        this.type = builder.type;
        this.synonyms = builder.synonyms;
        this.patterns = builder.patterns;
        this.includeAudit = builder.includeAudit;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String entity() {
        return this.entity;
    }

    public String value() {
        return this.value;
    }

    public Map<String, Object> metadata() {
        return this.metadata;
    }

    public String type() {
        return this.type;
    }

    public List<String> synonyms() {
        return this.synonyms;
    }

    public List<String> patterns() {
        return this.patterns;
    }

    public Boolean includeAudit() {
        return this.includeAudit;
    }

    public static class Builder {
        private String workspaceId;
        private String entity;
        private String value;
        private Map<String, Object> metadata;
        private String type;
        private List<String> synonyms;
        private List<String> patterns;
        private Boolean includeAudit;

        private Builder(CreateValueOptions createValueOptions) {
            this.workspaceId = createValueOptions.workspaceId;
            this.entity = createValueOptions.entity;
            this.value = createValueOptions.value;
            this.metadata = createValueOptions.metadata;
            this.type = createValueOptions.type;
            this.synonyms = createValueOptions.synonyms;
            this.patterns = createValueOptions.patterns;
            this.includeAudit = createValueOptions.includeAudit;
        }

        public Builder() {
        }

        public Builder(String workspaceId, String entity, String value) {
            this.workspaceId = workspaceId;
            this.entity = entity;
            this.value = value;
        }

        public CreateValueOptions build() {
            return new CreateValueOptions(this);
        }

        public Builder addSynonym(String synonym) {
            Validator.notNull((Object)synonym, (String)"synonym cannot be null");
            if (this.synonyms == null) {
                this.synonyms = new ArrayList<String>();
            }
            this.synonyms.add(synonym);
            return this;
        }

        public Builder addPattern(String pattern) {
            Validator.notNull((Object)pattern, (String)"pattern cannot be null");
            if (this.patterns == null) {
                this.patterns = new ArrayList<String>();
            }
            this.patterns.add(pattern);
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder entity(String entity) {
            this.entity = entity;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder synonyms(List<String> synonyms) {
            this.synonyms = synonyms;
            return this;
        }

        public Builder patterns(List<String> patterns) {
            this.patterns = patterns;
            return this;
        }

        public Builder includeAudit(Boolean includeAudit) {
            this.includeAudit = includeAudit;
            return this;
        }
    }

    public static interface Type {
        public static final String SYNONYMS = "synonyms";
        public static final String PATTERNS = "patterns";
    }
}

