/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v1.model.DialogNodeOutputOptionsElement;
import com.ibm.watson.assistant.v1.model.DialogSuggestion;
import java.util.ArrayList;
import java.util.List;

public class RuntimeResponseGeneric
extends GenericModel {
    @SerializedName(value="response_type")
    protected String responseType;
    protected String text;
    protected Long time;
    protected Boolean typing;
    protected String source;
    protected String title;
    protected String description;
    protected String preference;
    protected List<DialogNodeOutputOptionsElement> options;
    @SerializedName(value="message_to_human_agent")
    protected String messageToHumanAgent;
    protected String topic;
    @SerializedName(value="dialog_node")
    protected String dialogNode;
    protected List<DialogSuggestion> suggestions;

    protected RuntimeResponseGeneric(Builder builder) {
        Validator.notNull((Object)builder.responseType, (String)"responseType cannot be null");
        this.responseType = builder.responseType;
        this.text = builder.text;
        this.time = builder.time;
        this.typing = builder.typing;
        this.source = builder.source;
        this.title = builder.title;
        this.description = builder.description;
        this.preference = builder.preference;
        this.options = builder.options;
        this.messageToHumanAgent = builder.messageToHumanAgent;
        this.topic = builder.topic;
        this.dialogNode = builder.dialogNode;
        this.suggestions = builder.suggestions;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String responseType() {
        return this.responseType;
    }

    public String text() {
        return this.text;
    }

    public Long time() {
        return this.time;
    }

    public Boolean typing() {
        return this.typing;
    }

    public String source() {
        return this.source;
    }

    public String title() {
        return this.title;
    }

    public String description() {
        return this.description;
    }

    public String preference() {
        return this.preference;
    }

    public List<DialogNodeOutputOptionsElement> options() {
        return this.options;
    }

    public String messageToHumanAgent() {
        return this.messageToHumanAgent;
    }

    public String topic() {
        return this.topic;
    }

    public String dialogNode() {
        return this.dialogNode;
    }

    public List<DialogSuggestion> suggestions() {
        return this.suggestions;
    }

    public static class Builder {
        private String responseType;
        private String text;
        private Long time;
        private Boolean typing;
        private String source;
        private String title;
        private String description;
        private String preference;
        private List<DialogNodeOutputOptionsElement> options;
        private String messageToHumanAgent;
        private String topic;
        private String dialogNode;
        private List<DialogSuggestion> suggestions;

        private Builder(RuntimeResponseGeneric runtimeResponseGeneric) {
            this.responseType = runtimeResponseGeneric.responseType;
            this.text = runtimeResponseGeneric.text;
            this.time = runtimeResponseGeneric.time;
            this.typing = runtimeResponseGeneric.typing;
            this.source = runtimeResponseGeneric.source;
            this.title = runtimeResponseGeneric.title;
            this.description = runtimeResponseGeneric.description;
            this.preference = runtimeResponseGeneric.preference;
            this.options = runtimeResponseGeneric.options;
            this.messageToHumanAgent = runtimeResponseGeneric.messageToHumanAgent;
            this.topic = runtimeResponseGeneric.topic;
            this.dialogNode = runtimeResponseGeneric.dialogNode;
            this.suggestions = runtimeResponseGeneric.suggestions;
        }

        public Builder() {
        }

        public Builder(String responseType) {
            this.responseType = responseType;
        }

        public RuntimeResponseGeneric build() {
            return new RuntimeResponseGeneric(this);
        }

        public Builder addOptions(DialogNodeOutputOptionsElement options) {
            Validator.notNull((Object)((Object)options), (String)"options cannot be null");
            if (this.options == null) {
                this.options = new ArrayList<DialogNodeOutputOptionsElement>();
            }
            this.options.add(options);
            return this;
        }

        public Builder addSuggestions(DialogSuggestion suggestions) {
            Validator.notNull((Object)((Object)suggestions), (String)"suggestions cannot be null");
            if (this.suggestions == null) {
                this.suggestions = new ArrayList<DialogSuggestion>();
            }
            this.suggestions.add(suggestions);
            return this;
        }

        public Builder responseType(String responseType) {
            this.responseType = responseType;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder time(long time) {
            this.time = time;
            return this;
        }

        public Builder typing(Boolean typing) {
            this.typing = typing;
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder preference(String preference) {
            this.preference = preference;
            return this;
        }

        public Builder options(List<DialogNodeOutputOptionsElement> options) {
            this.options = options;
            return this;
        }

        public Builder messageToHumanAgent(String messageToHumanAgent) {
            this.messageToHumanAgent = messageToHumanAgent;
            return this;
        }

        public Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public Builder dialogNode(String dialogNode) {
            this.dialogNode = dialogNode;
            return this;
        }

        public Builder suggestions(List<DialogSuggestion> suggestions) {
            this.suggestions = suggestions;
            return this;
        }
    }

    public static interface Preference {
        public static final String DROPDOWN = "dropdown";
        public static final String BUTTON = "button";
    }

    public static interface ResponseType {
        public static final String TEXT = "text";
        public static final String PAUSE = "pause";
        public static final String IMAGE = "image";
        public static final String OPTION = "option";
        public static final String CONNECT_TO_AGENT = "connect_to_agent";
        public static final String SUGGESTION = "suggestion";
    }
}

