/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v1.model.Example;
import java.util.ArrayList;
import java.util.List;

public class UpdateIntentOptions
extends GenericModel {
    protected String workspaceId;
    protected String intent;
    protected String newIntent;
    protected String newDescription;
    protected List<Example> newExamples;
    protected Boolean append;
    protected Boolean includeAudit;

    protected UpdateIntentOptions(Builder builder) {
        Validator.notEmpty((String)builder.workspaceId, (String)"workspaceId cannot be empty");
        Validator.notEmpty((String)builder.intent, (String)"intent cannot be empty");
        this.workspaceId = builder.workspaceId;
        this.intent = builder.intent;
        this.newIntent = builder.newIntent;
        this.newDescription = builder.newDescription;
        this.newExamples = builder.newExamples;
        this.append = builder.append;
        this.includeAudit = builder.includeAudit;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String intent() {
        return this.intent;
    }

    public String newIntent() {
        return this.newIntent;
    }

    public String newDescription() {
        return this.newDescription;
    }

    public List<Example> newExamples() {
        return this.newExamples;
    }

    public Boolean append() {
        return this.append;
    }

    public Boolean includeAudit() {
        return this.includeAudit;
    }

    public static class Builder {
        private String workspaceId;
        private String intent;
        private String newIntent;
        private String newDescription;
        private List<Example> newExamples;
        private Boolean append;
        private Boolean includeAudit;

        private Builder(UpdateIntentOptions updateIntentOptions) {
            this.workspaceId = updateIntentOptions.workspaceId;
            this.intent = updateIntentOptions.intent;
            this.newIntent = updateIntentOptions.newIntent;
            this.newDescription = updateIntentOptions.newDescription;
            this.newExamples = updateIntentOptions.newExamples;
            this.append = updateIntentOptions.append;
            this.includeAudit = updateIntentOptions.includeAudit;
        }

        public Builder() {
        }

        public Builder(String workspaceId, String intent) {
            this.workspaceId = workspaceId;
            this.intent = intent;
        }

        public UpdateIntentOptions build() {
            return new UpdateIntentOptions(this);
        }

        public Builder addExample(Example example) {
            Validator.notNull((Object)((Object)example), (String)"example cannot be null");
            if (this.newExamples == null) {
                this.newExamples = new ArrayList<Example>();
            }
            this.newExamples.add(example);
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder intent(String intent) {
            this.intent = intent;
            return this;
        }

        public Builder newIntent(String newIntent) {
            this.newIntent = newIntent;
            return this;
        }

        public Builder newDescription(String newDescription) {
            this.newDescription = newDescription;
            return this;
        }

        public Builder newExamples(List<Example> newExamples) {
            this.newExamples = newExamples;
            return this;
        }

        public Builder append(Boolean append) {
            this.append = append;
            return this;
        }

        public Builder includeAudit(Boolean includeAudit) {
            this.includeAudit = includeAudit;
            return this;
        }
    }
}

