/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v2;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v2.model.CreateSessionOptions;
import com.ibm.watson.assistant.v2.model.DeleteSessionOptions;
import com.ibm.watson.assistant.v2.model.MessageOptions;
import com.ibm.watson.assistant.v2.model.MessageResponse;
import com.ibm.watson.assistant.v2.model.SessionResponse;
import com.ibm.watson.common.SdkCommon;
import java.lang.reflect.Type;
import java.util.Map;
import okhttp3.HttpUrl;

public class Assistant
extends BaseService {
    private static final String DEFAULT_SERVICE_NAME = "assistant";
    private static final String DEFAULT_SERVICE_URL = "https://gateway.watsonplatform.net/assistant/api";
    private String versionDate;

    public Assistant(String versionDate) {
        this(versionDate, DEFAULT_SERVICE_NAME, ConfigBasedAuthenticatorFactory.getAuthenticator((String)DEFAULT_SERVICE_NAME));
    }

    public Assistant(String versionDate, Authenticator authenticator) {
        this(versionDate, DEFAULT_SERVICE_NAME, authenticator);
    }

    public Assistant(String versionDate, String serviceName) {
        this(versionDate, serviceName, ConfigBasedAuthenticatorFactory.getAuthenticator((String)serviceName));
    }

    public Assistant(String versionDate, String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
        this.setServiceUrl(DEFAULT_SERVICE_URL);
        Validator.isTrue((versionDate != null && !versionDate.isEmpty() ? 1 : 0) != 0, (String)"version cannot be null.");
        this.versionDate = versionDate;
        this.configureService(serviceName);
    }

    public ServiceCall<SessionResponse> createSession(CreateSessionOptions createSessionOptions) {
        Validator.notNull((Object)((Object)createSessionOptions), (String)"createSessionOptions cannot be null");
        String[] pathSegments = new String[]{"v2/assistants", "sessions"};
        String[] pathParameters = new String[]{createSessionOptions.assistantId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"createSession");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SessionResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteSession(DeleteSessionOptions deleteSessionOptions) {
        Validator.notNull((Object)((Object)deleteSessionOptions), (String)"deleteSessionOptions cannot be null");
        String[] pathSegments = new String[]{"v2/assistants", "sessions"};
        String[] pathParameters = new String[]{deleteSessionOptions.assistantId(), deleteSessionOptions.sessionId()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"deleteSession");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<MessageResponse> message(MessageOptions messageOptions) {
        Validator.notNull((Object)((Object)messageOptions), (String)"messageOptions cannot be null");
        String[] pathSegments = new String[]{"v2/assistants", "sessions", "message"};
        String[] pathParameters = new String[]{messageOptions.assistantId(), messageOptions.sessionId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"conversation", (String)"v2", (String)"message");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (messageOptions.input() != null) {
            contentJson.add("input", GsonSingleton.getGson().toJsonTree((Object)messageOptions.input()));
        }
        if (messageOptions.context() != null) {
            contentJson.add("context", GsonSingleton.getGson().toJsonTree((Object)messageOptions.context()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<MessageResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }
}

