/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.assistant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.assistant.v1.model.BulkClassifyUtterance;
import java.util.ArrayList;
import java.util.List;

public class BulkClassifyOptions
extends GenericModel {
    protected String workspaceId;
    protected List<BulkClassifyUtterance> input;

    protected BulkClassifyOptions(Builder builder) {
        Validator.notEmpty((String)builder.workspaceId, (String)"workspaceId cannot be empty");
        this.workspaceId = builder.workspaceId;
        this.input = builder.input;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public List<BulkClassifyUtterance> input() {
        return this.input;
    }

    public static class Builder {
        private String workspaceId;
        private List<BulkClassifyUtterance> input;

        private Builder(BulkClassifyOptions bulkClassifyOptions) {
            this.workspaceId = bulkClassifyOptions.workspaceId;
            this.input = bulkClassifyOptions.input;
        }

        public Builder() {
        }

        public Builder(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        public BulkClassifyOptions build() {
            return new BulkClassifyOptions(this);
        }

        public Builder addInput(BulkClassifyUtterance input) {
            Validator.notNull((Object)((Object)input), (String)"input cannot be null");
            if (this.input == null) {
                this.input = new ArrayList<BulkClassifyUtterance>();
            }
            this.input.add(input);
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder input(List<BulkClassifyUtterance> input) {
            this.input = input;
            return this;
        }
    }
}

